/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.Sets;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Set;

public final class FormatProperties {
    private FormatProperties() {
    }

    public static void validateProperties(String formatName, Map<String, String> properties, Set<String> supportedProperties) {
        Sets.SetView diff = Sets.difference(properties.keySet(), supportedProperties);
        if (!diff.isEmpty()) {
            throw new KsqlException(formatName + " does not support the following configs: " + String.valueOf(diff));
        }
        properties.forEach((k, v) -> {
            if (v.trim().isEmpty()) {
                throw new KsqlException(k + " cannot be empty. Format configuration: " + String.valueOf(properties));
            }
        });
    }
}

