/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlPrimitiveType;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericDeserializer;
import io.confluent.ksql.serde.GenericSerdeFactory;
import io.confluent.ksql.serde.GenericSerializer;
import io.confluent.ksql.serde.KeySerdeFactory;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.serde.tracked.TrackedCallback;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;

public final class GenericKeySerDe
implements KeySerdeFactory {
    private final GenericSerdeFactory innerFactory;
    private Optional<String> queryId;

    public GenericKeySerDe() {
        this(new GenericSerdeFactory(), Optional.empty());
    }

    public GenericKeySerDe(String queryId) {
        this(new GenericSerdeFactory(), Optional.of(queryId));
    }

    @VisibleForTesting
    GenericKeySerDe(GenericSerdeFactory innerFactory, Optional<String> queryId) {
        this.innerFactory = Objects.requireNonNull(innerFactory, "innerFactory");
        this.queryId = queryId;
    }

    @Override
    public Serde<GenericKey> create(FormatInfo format, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext, Optional<TrackedCallback> tracker) {
        return this.createInner(format, schema, ksqlConfig, schemaRegistryClientFactory, loggerNamePrefix, processingLogContext, tracker);
    }

    @Override
    public Serde<Windowed<GenericKey>> create(FormatInfo format, WindowInfo window, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext, Optional<TrackedCallback> tracker) {
        Serde<GenericKey> inner = this.createInner(format, schema, ksqlConfig, schemaRegistryClientFactory, loggerNamePrefix, processingLogContext, tracker);
        return window.getType().requiresWindowSize() ? new WindowedSerdes.TimeWindowedSerde(inner, ((Duration)window.getSize().get()).toMillis()) : new WindowedSerdes.SessionWindowedSerde(inner);
    }

    private Serde<GenericKey> createInner(FormatInfo format, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext, Optional<TrackedCallback> tracker) {
        GenericKeySerDe.checkUnsupportedSchema(schema.columns(), ksqlConfig);
        Serde<List<?>> formatSerde = this.innerFactory.createFormatSerde("Key", format, schema, ksqlConfig, schemaRegistryClientFactory, true);
        Serde<GenericKey> genericKeySerde = GenericKeySerDe.toGenericKeySerde(formatSerde, schema);
        Serde<GenericKey> loggingSerde = this.innerFactory.wrapInLoggingSerde(genericKeySerde, loggerNamePrefix, processingLogContext, this.queryId);
        Serde<GenericKey> serde = tracker.map(callback -> this.innerFactory.wrapInTrackingSerde(loggingSerde, (TrackedCallback)callback)).orElse(loggingSerde);
        serde.configure(Collections.emptyMap(), true);
        return serde;
    }

    private static void checkUnsupportedSchema(List<SimpleColumn> columns, KsqlConfig config) {
        if (columns.isEmpty()) {
            return;
        }
        for (SimpleColumn column : columns) {
            if (!GenericKeySerDe.containsMapType(column.type())) continue;
            throw new KsqlException("Map keys, including types that contain maps, are not supported as they may lead to unexpected behavior due to inconsistent serialization. Key column name: " + String.valueOf(column.name()) + ". Column type: " + column.type().toString(FormatOptions.none()) + ". See https://github.com/confluentinc/ksql/issues/6621 for more.");
        }
    }

    private static boolean containsMapType(SqlType type) {
        if (type instanceof SqlMap) {
            return true;
        }
        if (type instanceof SqlPrimitiveType || type instanceof SqlDecimal) {
            return false;
        }
        if (type instanceof SqlArray) {
            return GenericKeySerDe.containsMapType(((SqlArray)type).getItemType());
        }
        if (type instanceof SqlStruct) {
            return ((SqlStruct)type).fields().stream().map(SqlStruct.Field::type).anyMatch(GenericKeySerDe::containsMapType);
        }
        throw new IllegalStateException("Unexpected type: " + String.valueOf(type));
    }

    private static Serde<GenericKey> toGenericKeySerde(Serde<List<?>> innerSerde, PersistenceSchema schema) {
        GenericSerializer<GenericKey> serializer = new GenericSerializer<GenericKey>(GenericKey::values, innerSerde.serializer(), schema.columns().size());
        GenericDeserializer<GenericKey> deserializer = new GenericDeserializer<GenericKey>(GenericKey::fromList, innerSerde.deserializer(), schema.columns().size());
        return Serdes.serdeFrom(serializer, deserializer);
    }
}

