/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import io.confluent.ksql.serde.avro.AvroSchemas;
import io.confluent.ksql.serde.connect.ConnectSRSchemaDataTranslator;
import io.confluent.ksql.serde.connect.ConnectSchemas;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class AvroSRSchemaDataTranslator
extends ConnectSRSchemaDataTranslator {
    AvroSRSchemaDataTranslator(Schema schema) {
        super(schema);
    }

    private void copyArray(List originalData, Schema originalSchema, List array, Schema schema) {
        for (Object field : originalData) {
            if (field instanceof List) {
                ArrayList nestedArray = new ArrayList();
                this.copyArray((List)field, originalSchema.valueSchema(), nestedArray, schema.valueSchema());
                array.add(nestedArray);
                continue;
            }
            if (field instanceof Map) {
                HashMap nestedMap = new HashMap();
                this.copyMap((Map)field, originalSchema.valueSchema(), nestedMap, schema.valueSchema());
                array.add(nestedMap);
                continue;
            }
            if (field instanceof Struct) {
                Struct innerStruct = new Struct(schema.valueSchema());
                this.copyStruct((Struct)field, ((Struct)field).schema(), innerStruct, schema.valueSchema());
                array.add(innerStruct);
                continue;
            }
            array.add(field);
        }
    }

    private void copyMap(Map<String, Object> originalData, Schema originalSchema, Map map, Schema schema) {
        for (Map.Entry<String, Object> entry : originalData.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                ArrayList nestedArray = new ArrayList();
                this.copyArray((List)value, originalSchema.valueSchema(), nestedArray, schema.valueSchema());
                map.put(key, nestedArray);
                continue;
            }
            if (value instanceof Map) {
                HashMap nestedMap = new HashMap();
                this.copyMap((Map)value, originalSchema.valueSchema(), nestedMap, schema.valueSchema());
                map.put(key, nestedMap);
                continue;
            }
            if (value instanceof Struct) {
                Struct innerStruct = new Struct(schema.valueSchema());
                this.copyStruct((Struct)value, ((Struct)value).schema(), innerStruct, schema.valueSchema());
                map.put(key, innerStruct);
                continue;
            }
            map.put(key, value);
        }
    }

    private void copyStruct(Struct originalData, Schema originalSchema, Struct struct, Schema schema) {
        for (Field field : schema.fields()) {
            Optional<Field> originalField = originalSchema.fields().stream().filter(f -> field.name().equals(f.name())).findFirst();
            if (originalField.isPresent()) {
                Object data = originalData.get(field);
                Schema dataSchema = originalField.get().schema();
                if (data instanceof List) {
                    ArrayList array = new ArrayList();
                    this.copyArray((List)data, dataSchema, array, field.schema());
                    struct.put(field, array);
                    continue;
                }
                if (data instanceof Map) {
                    HashMap map = new HashMap();
                    this.copyMap((Map)data, dataSchema, map, field.schema());
                    struct.put(field, map);
                    continue;
                }
                if (data instanceof Struct) {
                    Struct innerStruct = new Struct(field.schema());
                    this.copyStruct((Struct)data, dataSchema, innerStruct, field.schema());
                    struct.put(field, (Object)innerStruct);
                    continue;
                }
                struct.put(field, data);
                continue;
            }
            this.addDefaultValueOrThrowException(field, struct);
        }
    }

    private void addDefaultValueOrThrowException(Field field, Struct struct) {
        if (field.schema().defaultValue() == null && !field.schema().isOptional()) {
            throw new KsqlException("Missing default value for required Avro field: [" + field.name() + "]. This field appears in Avro schema in Schema Registry");
        }
        struct.put(field, field.schema().defaultValue());
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        if (!(ksqlData instanceof Struct)) {
            return ksqlData;
        }
        Schema schema = this.getSchema();
        Struct struct = new Struct(schema);
        Struct originalData = (Struct)ksqlData;
        Schema originalSchema = originalData.schema();
        if (originalSchema.name() == null && schema.name() != null) {
            originalSchema = AvroSchemas.getAvroCompatibleConnectSchema(originalSchema, schema.name());
            originalData = ConnectSchemas.withCompatibleRowSchema(originalData, originalSchema);
        }
        this.validate(originalSchema, schema);
        this.copyStruct(originalData, originalSchema, struct, schema);
        return struct;
    }
}

