/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

final class AvroSchemas {
    private AvroSchemas() {
    }

    public static Schema getAvroCompatibleConnectSchema(Schema schema, String schemaFullName) {
        return AvroSchemas.buildAvroCompatibleSchema(schema, new Context(Collections.singleton(schemaFullName), true));
    }

    private static String avroCompatibleFieldName(Field field) {
        return field.name().replace(".", "_");
    }

    private static Schema buildAvroCompatibleSchema(Schema schema, Context context) {
        SchemaBuilder schemaBuilder;
        boolean notRoot = !context.root;
        context.root = false;
        switch (schema.type()) {
            default: {
                if (notRoot || !schema.isOptional()) {
                    return schema;
                }
                schemaBuilder = new SchemaBuilder(schema.type()).name(schema.name());
                break;
            }
            case STRUCT: {
                schemaBuilder = AvroSchemas.buildAvroCompatibleStruct(schema, context);
                break;
            }
            case ARRAY: {
                schemaBuilder = AvroSchemas.buildAvroCompatibleArray(schema, context);
                break;
            }
            case MAP: {
                schemaBuilder = AvroSchemas.buildAvroCompatibleMap(schema, context);
            }
        }
        if (schema.parameters() != null) {
            schemaBuilder.parameters(schema.parameters());
        }
        if (schema.isOptional() && notRoot) {
            schemaBuilder.optional();
        }
        return schemaBuilder.build();
    }

    private static SchemaBuilder buildAvroCompatibleMap(Schema schema, Context context) {
        Schema keySchema = AvroSchemas.buildAvroCompatibleSchema(schema.keySchema(), context.with("MapKey"));
        Schema valueSchema = AvroSchemas.buildAvroCompatibleSchema(schema.valueSchema(), context.with("MapValue"));
        SchemaBuilder schemaBuilder = SchemaBuilder.map((Schema)keySchema, (Schema)valueSchema);
        schemaBuilder.name(context.name());
        return schemaBuilder;
    }

    private static SchemaBuilder buildAvroCompatibleArray(Schema schema, Context context) {
        Schema valueSchema = AvroSchemas.buildAvroCompatibleSchema(schema.valueSchema(), context);
        return SchemaBuilder.array((Schema)valueSchema);
    }

    private static SchemaBuilder buildAvroCompatibleStruct(Schema schema, Context context) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        if (schema.name() == null) {
            schemaBuilder.name(context.name());
        } else {
            schemaBuilder.name(schema.name());
        }
        for (Field f : schema.fields()) {
            String fieldName = AvroSchemas.avroCompatibleFieldName(f);
            Schema fieldSchema = AvroSchemas.buildAvroCompatibleSchema(f.schema(), context.with(f.name()));
            schemaBuilder.field(fieldName, fieldSchema);
        }
        return schemaBuilder;
    }

    private static final class Context {
        private static final String DELIMITER = "_";
        static final String MAP_KEY_NAME = "MapKey";
        static final String MAP_VALUE_NAME = "MapValue";
        private final Iterable<String> names;
        private boolean root;

        private Context(Iterable<String> names, boolean root) {
            this.names = Objects.requireNonNull(names, "names");
            this.root = root;
        }

        Context with(String name) {
            return new Context(Iterables.concat(this.names, (Iterable)ImmutableList.of((Object)name)), this.root);
        }

        public String name() {
            return String.join((CharSequence)DELIMITER, this.names);
        }
    }
}

