/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.FormatProperties;
import java.util.Map;
import java.util.Optional;

@Immutable
public abstract class ConnectProperties {
    public static final String FULL_SCHEMA_NAME = "fullSchemaName";
    public static final String SCHEMA_ID = "schemaId";
    public static final String SUBJECT_NAME = "subjectName";
    protected final ImmutableMap<String, String> properties;

    public ConnectProperties(String formatName, Map<String, String> formatProps) {
        this.properties = ImmutableMap.copyOf(formatProps);
        FormatProperties.validateProperties(formatName, formatProps, this.getSupportedProperties());
    }

    public abstract ImmutableSet<String> getSupportedProperties();

    protected abstract String getDefaultFullSchemaName();

    public String getFullSchemaName() {
        return (String)this.properties.getOrDefault((Object)FULL_SCHEMA_NAME, (Object)this.getDefaultFullSchemaName());
    }

    public Optional<Integer> getSchemaId() {
        String schemaId = (String)this.properties.get((Object)SCHEMA_ID);
        return schemaId == null ? Optional.empty() : Optional.of(Integer.parseInt(schemaId));
    }

    public Optional<String> getSubjectName() {
        return Optional.ofNullable((String)this.properties.get((Object)SUBJECT_NAME));
    }
}

