/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.json;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.FormatProperties;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.connect.ConnectFormat;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.serde.json.JsonSchemaProperties;
import io.confluent.ksql.serde.json.JsonSchemaTranslator;
import io.confluent.ksql.serde.json.KsqlJsonSerdeFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;

public class JsonSchemaFormat
extends ConnectFormat {
    private static final ImmutableSet<SerdeFeature> SUPPORTED_FEATURES = ImmutableSet.of((Object)SerdeFeature.SCHEMA_INFERENCE, (Object)SerdeFeature.WRAP_SINGLES, (Object)SerdeFeature.UNWRAP_SINGLES);
    public static final String NAME = "JSON_SR";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="SUPPORTED_FEATURES is ImmutableSet")
    public Set<SerdeFeature> supportedFeatures() {
        return SUPPORTED_FEATURES;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return JsonSchemaProperties.SUPPORTED_PROPERTIES;
    }

    @Override
    public Set<String> getInheritableProperties() {
        return JsonSchemaProperties.INHERITABLE_PROPERTIES;
    }

    @Override
    protected ConnectSchemaTranslator getConnectSchemaTranslator(Map<String, String> formatProps) {
        FormatProperties.validateProperties(this.name(), formatProps, this.getSupportedProperties());
        return new JsonSchemaTranslator();
    }

    @Override
    protected <T> Serde<T> getConnectSerde(ConnectSchema connectSchema, Map<String, String> formatProps, KsqlConfig config, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        return new KsqlJsonSerdeFactory(new JsonSchemaProperties(formatProps)).createSerde((Schema)connectSchema, config, srFactory, targetType, isKey);
    }
}

