/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.json;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.connect.json.JsonSchemaConverter;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.connect.SchemaWalker;
import io.confluent.ksql.serde.SerdeFactory;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.ConnectSRSchemaDataTranslator;
import io.confluent.ksql.serde.connect.KsqlConnectDeserializer;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.json.JsonSchemaProperties;
import io.confluent.ksql.serde.json.JsonSchemaTranslator;
import io.confluent.ksql.serde.json.KsqlJsonDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.json.DecimalFormat;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;

@Immutable
class KsqlJsonSerdeFactory
implements SerdeFactory {
    private final boolean useSchemaRegistryFormat;
    private final JsonSchemaProperties properties;

    KsqlJsonSerdeFactory() {
        this.useSchemaRegistryFormat = false;
        this.properties = null;
    }

    KsqlJsonSerdeFactory(JsonSchemaProperties properties) {
        this.useSchemaRegistryFormat = true;
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    @Override
    public <T> Serde<T> createSerde(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        KsqlJsonSerdeFactory.validateSchema(schema);
        Optional<Object> physicalSchema = this.useSchemaRegistryFormat ? (this.properties.getSchemaId().isPresent() ? Optional.of(SerdeUtils.getAndTranslateSchemaById(srFactory, this.properties.getSchemaId().get(), new JsonSchemaTranslator())) : Optional.empty()) : Optional.empty();
        Converter converter = this.useSchemaRegistryFormat ? KsqlJsonSerdeFactory.getSchemaRegistryConverter(srFactory.get(), ksqlConfig, this.properties.getSchemaId(), isKey) : KsqlJsonSerdeFactory.getConverter();
        ConnectDataTranslator dataTranslator = physicalSchema.isPresent() ? new ConnectSRSchemaDataTranslator((Schema)physicalSchema.get()) : new ConnectDataTranslator(schema);
        Supplier serializer = () -> this.createSerializer(targetType, dataTranslator, converter);
        Deserializer<T> deserializer = this.createDeserializer(ksqlConfig, schema, targetType, dataTranslator, converter);
        serializer.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer(serializer), deserializer);
    }

    private <T> Serializer<T> createSerializer(Class<T> targetType, ConnectDataTranslator dataTranslator, Converter converter) {
        return new KsqlConnectSerializer<T>(dataTranslator.getSchema(), dataTranslator, converter, targetType);
    }

    private <T> Deserializer<T> createDeserializer(KsqlConfig ksqlConfig, Schema schema, Class<T> targetType, ConnectDataTranslator dataTranslator, Converter converter) {
        if (this.useSchemaRegistryFormat && ksqlConfig.getBoolean("ksql.json_sr.converter.deserializer.enabled").booleanValue()) {
            return new KsqlConnectDeserializer<T>(converter, dataTranslator, targetType);
        }
        return new KsqlJsonDeserializer<T>(schema, this.useSchemaRegistryFormat, targetType);
    }

    private static Converter getConverter() {
        JsonConverter converter = new JsonConverter();
        converter.configure((Map)ImmutableMap.of((Object)"schemas.enable", (Object)false, (Object)"decimal.format", (Object)DecimalFormat.NUMERIC.name()), false);
        return converter;
    }

    private static Converter getSchemaRegistryConverter(SchemaRegistryClient schemaRegistryClient, KsqlConfig ksqlConfig, Optional<Integer> schemaId, boolean isKey) {
        Map config = ksqlConfig.originalsWithPrefix("ksql.schema.registry.");
        config.put("schema.registry.url", ksqlConfig.getString("ksql.schema.registry.url"));
        if (schemaId.isPresent()) {
            config.put("auto.register.schemas", false);
            config.put("use.schema.id", schemaId.get());
        }
        config.put("decimal.format", DecimalFormat.NUMERIC.name());
        JsonSchemaConverter converter = new JsonSchemaConverter(schemaRegistryClient);
        converter.configure(config, isKey);
        return converter;
    }

    private static Schema validateSchema(Schema schema) {
        class SchemaValidator
        implements SchemaWalker.Visitor<Void, Void> {
            SchemaValidator() {
            }

            public Void visitMap(Schema mapSchema, Void key, Void value) {
                if (mapSchema.keySchema().type() != Schema.Type.STRING) {
                    throw new KsqlException("JSON only supports MAP types with STRING keys");
                }
                return null;
            }

            public Void visitSchema(Schema schema11) {
                return null;
            }
        }
        SchemaWalker.visit((Schema)schema, (SchemaWalker.Visitor)new SchemaValidator());
        return schema;
    }
}

