/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.none;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatProperties;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.voids.KsqlVoidSerde;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;

public class NoneFormat
implements Format {
    public static final String NAME = "NONE";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Serde<List<?>> getSerde(PersistenceSchema schema, Map<String, String> formatProperties, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srClientFactory, boolean isKey) {
        FormatProperties.validateProperties(this.name(), formatProperties, this.getSupportedProperties());
        SerdeUtils.throwOnUnsupportedFeatures(schema.features(), this.supportedFeatures());
        if (!schema.columns().isEmpty()) {
            throw new KsqlException("The 'NONE' format can only be used when no columns are defined. Got: " + String.valueOf(schema.columns()));
        }
        return new KsqlVoidSerde();
    }

    @Override
    public boolean supportsKeyType(SqlType type) {
        return false;
    }
}

