/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.unwrapped;

import io.confluent.ksql.serde.SerdeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class UnwrappedSerializer<T>
implements Serializer<List<?>> {
    private final Serializer<T> inner;
    private final Class<T> colType;

    public UnwrappedSerializer(Serializer<T> inner, Class<T> colType) {
        this.inner = Objects.requireNonNull(inner, "inner");
        this.colType = Objects.requireNonNull(colType, "colType");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
    }

    public byte[] serialize(String topic, List<?> values) {
        if (values == null) {
            return null;
        }
        T single = this.extractOnlyColumn(values, topic);
        return this.inner.serialize(topic, single);
    }

    public byte[] serialize(String topic, Headers headers, List<?> struct) {
        if (struct == null) {
            return null;
        }
        T single = this.extractOnlyColumn(struct, topic);
        return this.inner.serialize(topic, headers, single);
    }

    public void close() {
        this.inner.close();
    }

    private T extractOnlyColumn(List<?> values, String topic) {
        SerdeUtils.throwOnColumnCountMismatch(1, values.size(), true, topic);
        Object val = values.get(0);
        return SerdeUtils.safeCast(val, this.colType);
    }
}

