/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.network.GenericConnectionQuotaEntity;
import org.apache.kafka.network.ListenerConnectionQuotaEntity;

public class ListenerTenantQuotaEntity
implements ListenerConnectionQuotaEntity,
GenericConnectionQuotaEntity {
    private final String tenantId;
    private final String listenerName;

    public ListenerTenantQuotaEntity(String tenantId, String listenerName) {
        this.tenantId = tenantId;
        this.listenerName = listenerName;
    }

    @Override
    public String rateSensorName() {
        return "Connection-Accept-Rate-" + this.listenerName + "-" + this.tenantId;
    }

    @Override
    public String countSensorName() {
        return "Connection-Count-" + this.listenerName + "-" + this.tenantId;
    }

    @Override
    public long sensorExpiration() {
        return INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS;
    }

    @Override
    public String quotaMetricName() {
        return "connection-tokens";
    }

    @Override
    public String countMetricName() {
        return "authenticated-unthrottled-connection-count";
    }

    @Override
    public Map<String, String> metricTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tenant", this.tenantId);
        tags.put("listener", this.listenerName);
        return tags;
    }

    @Override
    public String domain() {
        return "listener-tenant";
    }

    @Override
    public String entityName() {
        return this.tenantId;
    }
}

