/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Set;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.common.FinalizedFeatures;

public interface ApiVersionManager {
    public static final Set<Short> INTER_BROKER_ONLY_APIS = Set.of(Short.valueOf(ApiKeys.INITIALIZE_SHARE_GROUP_STATE.id), Short.valueOf(ApiKeys.READ_SHARE_GROUP_STATE.id), Short.valueOf(ApiKeys.WRITE_SHARE_GROUP_STATE.id), Short.valueOf(ApiKeys.DELETE_SHARE_GROUP_STATE.id), Short.valueOf(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY.id));

    public boolean enableUnstableLastVersion();

    public ApiMessageType.ApiVisibility apiVisibility();

    public ApiMessageType.ListenerType listenerType();

    public Set<ApiKeys> enabledApis();

    public ApiVersionsResponse apiVersionResponse(int var1, boolean var2, boolean var3);

    default public ApiVersionsResponse apiVersionResponse(int throttleTimeMs, boolean alterFeatureLevel0) {
        return this.apiVersionResponse(throttleTimeMs, alterFeatureLevel0, true);
    }

    public FinalizedFeatures features();

    default public boolean isApiEnabled(ApiKeys apiKey, short apiVersion) {
        return apiKey != null && apiKey.inScope(this.listenerType()) && apiKey.isVersionEnabled(apiVersion, this.enableUnstableLastVersion()) && apiKey.isApiVisible(this.apiVisibility());
    }

    default public RequestChannelMetrics newRequestMetrics() {
        return new RequestChannelMetrics(ApiKeys.apisForListener((ApiMessageType.ListenerType)this.listenerType()));
    }

    default public ApiVersionsResponseData.ApiVersionCollection filterApiVersions(ApiVersionsResponseData.ApiVersionCollection apiVersions, boolean includeInterBroker) {
        ApiVersionsResponseData.ApiVersionCollection apis = apiVersions;
        if (!includeInterBroker) {
            ApiVersionsResponseData.ApiVersionCollection tempApiVersions = apis.duplicate();
            tempApiVersions.removeIf(apiVersion -> INTER_BROKER_ONLY_APIS.contains(apiVersion.apiKey()));
            apis = tempApiVersions;
        }
        return apis;
    }
}

