/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import org.apache.kafka.common.config.ConfigDef;

public class KRaftConfigs {
    public static final String PROCESS_ROLES_CONFIG = "process.roles";
    public static final String PROCESS_ROLES_DOC = "The roles that this process plays: 'broker', 'controller', or 'broker,controller' if it is both. ";
    public static final String INITIAL_BROKER_REGISTRATION_TIMEOUT_MS_CONFIG = "initial.broker.registration.timeout.ms";
    public static final int INITIAL_BROKER_REGISTRATION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String INITIAL_BROKER_REGISTRATION_TIMEOUT_MS_DOC = "When initially registering with the controller quorum, the number of milliseconds to wait before declaring failure and exiting the broker process.";
    public static final String BROKER_HEARTBEAT_INTERVAL_MS_CONFIG = "broker.heartbeat.interval.ms";
    public static final int BROKER_HEARTBEAT_INTERVAL_MS_DEFAULT = 2000;
    public static final String BROKER_HEARTBEAT_INTERVAL_MS_DOC = "The length of time in milliseconds between broker heartbeats.";
    public static final String BROKER_SESSION_TIMEOUT_MS_CONFIG = "broker.session.timeout.ms";
    public static final int BROKER_SESSION_TIMEOUT_MS_DEFAULT = 9000;
    public static final String BROKER_SESSION_TIMEOUT_MS_DOC = "The length of time in milliseconds that a broker lease lasts if no heartbeats are made.";
    public static final String NODE_ID_CONFIG = "node.id";
    public static final String NODE_ID_DOC = "The node ID associated with the roles this process is playing when <code>process.roles</code> is non-empty. This is required configuration when running in KRaft mode.";
    public static final String CONTROLLER_LISTENER_NAMES_CONFIG = "controller.listener.names";
    public static final String CONTROLLER_LISTENER_NAMES_DOC = "A comma-separated list of the names of the listeners used by the controller. This is required when communicating with the controller quorum, the broker will always use the first listener in this list.";
    public static final String SASL_MECHANISM_CONTROLLER_PROTOCOL_CONFIG = "sasl.mechanism.controller.protocol";
    public static final String SASL_MECHANISM_CONTROLLER_PROTOCOL_DOC = "SASL mechanism used for communication with controllers. Default is GSSAPI.";
    public static final String SERVER_MAX_STARTUP_TIME_MS_CONFIG = "server.max.startup.time.ms";
    public static final long SERVER_MAX_STARTUP_TIME_MS_DEFAULT = Long.MAX_VALUE;
    public static final String SERVER_MAX_STARTUP_TIME_MS_DOC = "The maximum number of milliseconds we will wait for the server to come up. By default there is no limit. This should be used for testing only.";
    public static final String CONTROLLER_PERFORMANCE_SAMPLE_PERIOD_MS = "controller.performance.sample.period.ms";
    public static final long CONTROLLER_PERFORMANCE_SAMPLE_PERIOD_MS_DEFAULT = 60000L;
    public static final String CONTROLLER_PERFORMANCE_SAMPLE_PERIOD_MS_DOC = "The number of milliseconds between periodic controller event performance log messages.";
    public static final String CONTROLLER_PERFORMANCE_ALWAYS_LOG_THRESHOLD_MS = "controller.performance.always.log.threshold.ms";
    public static final long CONTROLLER_PERFORMANCE_ALWAYS_LOG_THRESHOLD_MS_DEFAULT = 2000L;
    public static final String CONTROLLER_PERFORMANCE_ALWAYS_LOG_THRESHOLD_MS_DOC = "We will log an error message about controller events that take longer than this threshold.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("process.roles", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.ValidList.in((String[])new String[]{"broker", "controller"}), ConfigDef.Importance.HIGH, "The roles that this process plays: 'broker', 'controller', or 'broker,controller' if it is both. ").define("node.id", ConfigDef.Type.INT, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "The node ID associated with the roles this process is playing when <code>process.roles</code> is non-empty. This is required configuration when running in KRaft mode.").define("initial.broker.registration.timeout.ms", ConfigDef.Type.INT, (Object)60000, null, ConfigDef.Importance.MEDIUM, "When initially registering with the controller quorum, the number of milliseconds to wait before declaring failure and exiting the broker process.").define("broker.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)2000, null, ConfigDef.Importance.MEDIUM, "The length of time in milliseconds between broker heartbeats.").define("broker.session.timeout.ms", ConfigDef.Type.INT, (Object)9000, null, ConfigDef.Importance.MEDIUM, "The length of time in milliseconds that a broker lease lasts if no heartbeats are made.").define("controller.listener.names", ConfigDef.Type.STRING, null, null, ConfigDef.Importance.HIGH, "A comma-separated list of the names of the listeners used by the controller. This is required when communicating with the controller quorum, the broker will always use the first listener in this list.").define("sasl.mechanism.controller.protocol", ConfigDef.Type.STRING, (Object)"GSSAPI", null, ConfigDef.Importance.HIGH, "SASL mechanism used for communication with controllers. Default is GSSAPI.").defineInternal("controller.performance.sample.period.ms", ConfigDef.Type.LONG, (Object)60000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)100), ConfigDef.Importance.MEDIUM, "The number of milliseconds between periodic controller event performance log messages.").defineInternal("controller.performance.always.log.threshold.ms", ConfigDef.Type.LONG, (Object)2000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "We will log an error message about controller events that take longer than this threshold.").defineInternal("server.max.startup.time.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The maximum number of milliseconds we will wait for the server to come up. By default there is no limit. This should be used for testing only.").defineInternal("confluent.metadata.encryptor.required", ConfigDef.Type.BOOLEAN, (Object)false, null, ConfigDef.Importance.HIGH, "When true, the node will fail to start if no metadata log encryptor is available.").defineInternal("confluent.metadata.encryptor.secret.file", ConfigDef.Type.STRING, null, null, ConfigDef.Importance.HIGH, "K8s secret file to read for metadata encryptor secrets.");
}

