/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.replica;

import io.confluent.kafka.replication.push.ReplicationState;
import io.confluent.kafka.replication.push.ReplicationStateMetadata;
import java.util.Optional;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;

public record ReplicaState(long logStartOffset, LogOffsetMetadata logEndOffsetMetadata, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, long lastCaughtUpTimeMs, Optional<Long> brokerEpoch, ReplicationStateMetadata replicationSessionState) {
    public static final ReplicaState EMPTY = new ReplicaState(-1L, LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, 0L, 0L, 0L, Optional.empty(), ReplicationStateMetadata.INITIAL);

    public long logEndOffset() {
        return this.logEndOffsetMetadata.messageOffset;
    }

    public boolean isCaughtUp(long leaderEndOffset, long currentTimeMs, long replicaMaxLagMs) {
        return leaderEndOffset == this.logEndOffset() || currentTimeMs - this.lastCaughtUpTimeMs <= replicaMaxLagMs;
    }

    public boolean canUpdateBrokerEpochOrReplicationSession(long brokerEpoch, long replicationSessionId) {
        return !this.brokerEpoch.isPresent() || this.brokerEpoch.get() < brokerEpoch || this.brokerEpoch.get().equals(brokerEpoch) && this.replicationSessionState.canTransitionTo(ReplicationState.Mode.PULL, replicationSessionId);
    }

    public boolean canTransitionToPush(long brokerEpoch, long replicationSessionId) {
        return !this.isStaleBrokerEpochOrReplicationSession(brokerEpoch, replicationSessionId) && this.replicationSessionState.canTransitionTo(ReplicationState.Mode.PUSH, replicationSessionId);
    }

    private boolean isStaleBrokerEpochOrReplicationSession(long brokerEpoch, long replicationSessionId) {
        if (this.brokerEpoch.isPresent() && this.brokerEpoch.get().equals(brokerEpoch)) {
            return this.replicationSessionState.replicationSessionId() > replicationSessionId;
        }
        return this.brokerEpoch.isPresent() && this.brokerEpoch.get() > brokerEpoch;
    }

    public boolean isPushSessionActive(long brokerEpoch, long replicationSessionId) {
        return this.brokerEpoch.isPresent() && this.brokerEpoch.get().equals(brokerEpoch) && this.replicationSessionState.replicationSessionId() == replicationSessionId && this.replicationSessionState.mode() == ReplicationState.Mode.PUSH;
    }
}

