/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.share.fetch.AcquisitionLockTimeoutHandler;
import org.apache.kafka.server.share.metrics.SharePartitionMetrics;
import org.apache.kafka.server.util.timer.TimerTask;

public class AcquisitionLockTimerTask
extends TimerTask {
    private final long expirationMs;
    private final String memberId;
    private final long firstOffset;
    private final long lastOffset;
    private final AcquisitionLockTimeoutHandler timeoutHandler;
    private final SharePartitionMetrics sharePartitionMetrics;
    private volatile boolean hasExpired;

    public AcquisitionLockTimerTask(Time time, long delayMs, String memberId, long firstOffset, long lastOffset, AcquisitionLockTimeoutHandler timeoutHandler, SharePartitionMetrics sharePartitionMetrics) {
        super(delayMs);
        this.expirationMs = time.hiResClockMs() + delayMs;
        this.memberId = memberId;
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.timeoutHandler = timeoutHandler;
        this.sharePartitionMetrics = sharePartitionMetrics;
        this.hasExpired = false;
    }

    public long expirationMs() {
        return this.expirationMs;
    }

    public boolean hasExpired() {
        return this.hasExpired;
    }

    public void run() {
        this.hasExpired = true;
        this.sharePartitionMetrics.recordAcquisitionLockTimeoutPerSec(this.lastOffset - this.firstOffset + 1L);
        this.timeoutHandler.handle(this.memberId, this.firstOffset, this.lastOffset, this);
    }
}

