/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class SharePartitionMetrics
implements AutoCloseable {
    public static final String IN_FLIGHT_MESSAGE_COUNT = "InFlightMessageCount";
    public static final String IN_FLIGHT_BATCH_COUNT = "InFlightBatchCount";
    private static final String ACQUISITION_LOCK_TIMEOUT_PER_SEC = "AcquisitionLockTimeoutPerSec";
    private static final String IN_FLIGHT_BATCH_MESSAGE_COUNT = "InFlightBatchMessageCount";
    private static final String FETCH_LOCK_TIME_MS = "FetchLockTimeMs";
    private static final String FETCH_LOCK_RATIO = "FetchLockRatio";
    private final Meter acquisitionLockTimeoutPerSec;
    private final Histogram inFlightBatchMessageCount;
    private final Histogram fetchLockTimeMs;
    private final Histogram fetchLockRatio;
    private final Map<String, String> tags;
    private final KafkaMetricsGroup metricsGroup;

    public SharePartitionMetrics(String groupId, String topic, int partition) {
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"group", (Object)Objects.requireNonNull(groupId)), Utils.mkEntry((Object)"topic", (Object)Objects.requireNonNull(topic))});
        this.metricsGroup = new KafkaMetricsGroup("kafka.server", "SharePartitionMetrics");
        this.acquisitionLockTimeoutPerSec = this.metricsGroup.newMeter(ACQUISITION_LOCK_TIMEOUT_PER_SEC, "acquisition lock timeout", TimeUnit.SECONDS, this.tags);
        this.inFlightBatchMessageCount = this.metricsGroup.newHistogram(IN_FLIGHT_BATCH_MESSAGE_COUNT, true, this.tags);
        this.fetchLockTimeMs = this.metricsGroup.newHistogram(FETCH_LOCK_TIME_MS, true, this.tags);
        this.fetchLockRatio = this.metricsGroup.newHistogram(FETCH_LOCK_RATIO, true, this.tags);
    }

    public void registerInFlightMessageCount(Supplier<Integer> messageCountSupplier) {
        this.metricsGroup.newGauge(IN_FLIGHT_MESSAGE_COUNT, messageCountSupplier, this.tags);
    }

    public void registerInFlightBatchCount(Supplier<Integer> batchCountSupplier) {
        this.metricsGroup.newGauge(IN_FLIGHT_BATCH_COUNT, batchCountSupplier, this.tags);
    }

    public void recordAcquisitionLockTimeoutPerSec(long count) {
        this.acquisitionLockTimeoutPerSec.mark(count);
    }

    public void recordInFlightBatchMessageCount(long count) {
        this.inFlightBatchMessageCount.update(count);
    }

    public void recordFetchLockTimeMs(long timeMs) {
        this.fetchLockTimeMs.update(timeMs);
    }

    public void recordFetchLockRatio(int value) {
        this.fetchLockRatio.update(value);
    }

    public Meter acquisitionLockTimeoutPerSec() {
        return this.acquisitionLockTimeoutPerSec;
    }

    public Histogram inFlightBatchMessageCount() {
        return this.inFlightBatchMessageCount;
    }

    public Histogram fetchLockTimeMs() {
        return this.fetchLockTimeMs;
    }

    public Histogram fetchLockRatio() {
        return this.fetchLockRatio;
    }

    @Override
    public void close() throws Exception {
        List.of(ACQUISITION_LOCK_TIMEOUT_PER_SEC, IN_FLIGHT_MESSAGE_COUNT, IN_FLIGHT_BATCH_COUNT, IN_FLIGHT_BATCH_MESSAGE_COUNT, FETCH_LOCK_TIME_MS, FETCH_LOCK_RATIO).forEach(m -> this.metricsGroup.removeMetric(m, this.tags));
    }
}

