/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.session;

import com.yammer.metrics.core.Meter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.ShareRequestMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.ShareGroupListener;
import org.apache.kafka.server.share.session.ShareSession;
import org.apache.kafka.server.share.session.ShareSessionKey;

public class ShareSessionCache {
    static final String SHARE_SESSIONS_COUNT = "ShareSessionsCount";
    static final String SHARE_PARTITIONS_COUNT = "SharePartitionsCount";
    private static final String SHARE_SESSION_EVICTIONS_PER_SEC = "ShareSessionEvictionsPerSec";
    private final Meter evictionsMeter;
    private final ConnectionDisconnectListener connectionDisconnectListener;
    private final Map<ShareSessionKey, ShareSession> sessions = new HashMap<ShareSessionKey, ShareSession>();
    private final Map<String, Integer> numMembersPerGroup = new HashMap<String, Integer>();
    private final Map<String, ShareSessionKey> connectionIdToSessionMap;
    private ShareGroupListener shareGroupListener;
    private final int maxEntries;
    private long numPartitions = 0L;

    public ShareSessionCache(int maxEntries) {
        this.maxEntries = maxEntries;
        KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup("kafka.server", "ShareSessionCache");
        metricsGroup.newGauge(SHARE_SESSIONS_COUNT, this::size);
        metricsGroup.newGauge(SHARE_PARTITIONS_COUNT, this::totalPartitions);
        this.connectionIdToSessionMap = new HashMap<String, ShareSessionKey>();
        this.connectionDisconnectListener = new ClientConnectionDisconnectListener();
        this.evictionsMeter = metricsGroup.newMeter(SHARE_SESSION_EVICTIONS_PER_SEC, "evictions", TimeUnit.SECONDS);
    }

    public synchronized ShareSession get(ShareSessionKey key) {
        return this.sessions.getOrDefault(key, null);
    }

    public synchronized int size() {
        return this.sessions.size();
    }

    public synchronized void removeAllSessions() {
        this.sessions.clear();
        this.numMembersPerGroup.clear();
        this.numPartitions = 0L;
    }

    public synchronized long totalPartitions() {
        return this.numPartitions;
    }

    public synchronized ShareSession remove(ShareSessionKey key) {
        ShareSession session = this.get(key);
        if (session != null) {
            return this.remove(session);
        }
        return null;
    }

    public synchronized void maybeRemoveAndNotifyListeners(ShareSessionKey key) {
        int numMembers;
        ShareSession session = this.get(key);
        if (session != null) {
            if (this.shareGroupListener != null) {
                this.shareGroupListener.onMemberLeave(key.groupId(), key.memberId());
            }
            this.evictionsMeter.mark();
            this.remove(session);
        }
        if ((numMembers = this.numMembersPerGroup.getOrDefault(key.groupId(), 0).intValue()) == 0) {
            this.numMembersPerGroup.remove(key.groupId());
            if (this.shareGroupListener != null) {
                this.shareGroupListener.onGroupEmpty(key.groupId());
            }
        }
    }

    public synchronized ShareSession remove(ShareSession session) {
        ShareSession removeResult = this.sessions.remove(session.key());
        if (removeResult != null) {
            this.numPartitions -= (long)session.cachedSize();
            this.numMembersPerGroup.compute(session.key().groupId(), (k, v) -> v != null ? v - 1 : 0);
        }
        return removeResult;
    }

    public synchronized void updateNumPartitions(ShareSession session) {
        this.numPartitions += (long)session.updateCachedSize();
    }

    public synchronized ShareSessionKey maybeCreateSession(String groupId, Uuid memberId, ImplicitLinkedHashCollection<CachedSharePartition> partitionMap, String clientConnectionId) {
        if (this.sessions.size() < this.maxEntries) {
            ShareSession session = new ShareSession(new ShareSessionKey(groupId, memberId), partitionMap, ShareRequestMetadata.nextEpoch((int)0));
            this.sessions.put(session.key(), session);
            this.updateNumPartitions(session);
            this.numMembersPerGroup.compute(session.key().groupId(), (k, v) -> v != null ? v + 1 : 1);
            this.connectionIdToSessionMap.put(clientConnectionId, session.key());
            return session.key();
        }
        return null;
    }

    public ConnectionDisconnectListener connectionDisconnectListener() {
        return this.connectionDisconnectListener;
    }

    public synchronized void registerShareGroupListener(ShareGroupListener shareGroupListener) {
        this.shareGroupListener = shareGroupListener;
    }

    Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    Integer numMembers(String groupId) {
        return this.numMembersPerGroup.get(groupId);
    }

    private final class ClientConnectionDisconnectListener
    implements ConnectionDisconnectListener {
        private ClientConnectionDisconnectListener() {
        }

        public void onDisconnect(String connectionId) {
            ShareSessionKey shareSessionKey = ShareSessionCache.this.connectionIdToSessionMap.remove(connectionId);
            if (shareSessionKey != null) {
                ShareSessionCache.this.maybeRemoveAndNotifyListeners(shareSessionKey);
            }
        }
    }
}

