/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore;

import com.google.common.collect.Iterables;
import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.function.TableFunctionFactory;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.metastore.MutableMetaStore;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.metastore.TypeRegistryImpl;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlReferentialIntegrityException;
import io.vertx.core.impl.ConcurrentHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafe
public final class MetaStoreImpl
implements MutableMetaStore {
    private static final Logger LOG = LogManager.getLogger(MetaStoreImpl.class);
    private final Map<SourceName, Set<SourceName>> dropConstraints = new ConcurrentHashMap<SourceName, Set<SourceName>>();
    private final Map<SourceName, SourceInfo> dataSources = new ConcurrentHashMap<SourceName, SourceInfo>();
    private final Object metaStoreLock = new Object();
    private final FunctionRegistry functionRegistry;
    private final TypeRegistry typeRegistry;

    public MetaStoreImpl(FunctionRegistry functionRegistry) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.typeRegistry = new TypeRegistryImpl();
    }

    private MetaStoreImpl(Map<SourceName, SourceInfo> dataSources, FunctionRegistry functionRegistry, TypeRegistry typeRegistry, Map<SourceName, Set<SourceName>> dropConstraints) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.typeRegistry = new TypeRegistryImpl();
        dataSources.forEach((name, info) -> this.dataSources.put((SourceName)name, info.copy()));
        typeRegistry.types().forEachRemaining(type -> this.typeRegistry.registerType(type.getName(), type.getType()));
        dropConstraints.forEach((source, references) -> {
            ConcurrentHashSet childSources = new ConcurrentHashSet();
            childSources.addAll(references);
            this.dropConstraints.put((SourceName)source, (Set<SourceName>)childSources);
        });
    }

    @Override
    public DataSource getSource(SourceName sourceName) {
        SourceInfo source = this.dataSources.get(sourceName);
        if (source == null) {
            return null;
        }
        return source.source;
    }

    @Override
    public void putSource(DataSource dataSource, boolean allowReplace) {
        SourceInfo existing = this.dataSources.get(dataSource.getName());
        if (existing != null && !allowReplace) {
            SourceName name2 = dataSource.getName();
            String newType = dataSource.getDataSourceType().getKsqlType().toLowerCase();
            String existingType = existing.source.getDataSourceType().getKsqlType().toLowerCase();
            throw new KsqlException(String.format("Cannot add %s '%s': A %s with the same name already exists", newType, name2.text(), existingType));
        }
        if (existing != null) {
            existing.source.canUpgradeTo(dataSource).ifPresent(msg -> {
                throw new KsqlException("Cannot upgrade data source: " + msg);
            });
        }
        this.dataSources.put(dataSource.getName(), existing != null ? existing.copyWith(dataSource) : new SourceInfo(dataSource));
        LOG.info("Source {} created on the metastore", (Object)dataSource.getName().text());
        this.dataSources.forEach((name, info) -> info.references.forEach(ref -> {
            if (ref.equals((Object)dataSource.getName())) {
                LOG.debug("Add a drop constraint reference back to source '{}' from source '{}'", (Object)dataSource.getName().text(), (Object)name.text());
                this.addConstraint(dataSource.getName(), (SourceName)name);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSource(SourceName sourceName, boolean restoreInProgress) {
        Object object = this.metaStoreLock;
        synchronized (object) {
            this.dataSources.compute(sourceName, (ignored, sourceInfo) -> {
                if (sourceInfo == null) {
                    throw new KsqlException(String.format("No data source with name %s exists.", sourceName.text()));
                }
                if (this.dropConstraints.containsKey(sourceName)) {
                    String references = this.dropConstraints.get(sourceName).stream().map(Name::text).sorted().collect(Collectors.joining(", "));
                    if (restoreInProgress) {
                        LOG.warn("The following streams and/or tables read from the '{}' source: [{}].\nIgnoring DROP constraints when restoring the metastore. \nFuture CREATE statements that recreate this '{}' source may not have DROP constraints if existing source references exist.", (Object)sourceName.text(), (Object)references);
                        this.dropConstraints.remove(sourceName);
                    } else {
                        throw new KsqlReferentialIntegrityException(String.format("Cannot drop %s.%nThe following streams and/or tables read from this source: [%s].%nYou need to drop them before dropping %s.", sourceName.text(), references, sourceName.text()));
                    }
                }
                sourceInfo.references.stream().forEach(ref -> this.dropConstraint((SourceName)ref, sourceName));
                LOG.info("Source {} deleted from the metastore", (Object)sourceName.text());
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceReferences(SourceName sourceName, Set<SourceName> sourceReferences) {
        Object object = this.metaStoreLock;
        synchronized (object) {
            if (sourceReferences.contains(sourceName)) {
                throw new KsqlException(String.format("Source name '%s' should not be referenced itself.", sourceName.text()));
            }
            Iterables.concat(Collections.singleton(sourceName), sourceReferences).forEach(name -> {
                if (!this.dataSources.containsKey(name)) {
                    throw new KsqlException(String.format("No data source with name '%s' exists.", name.text()));
                }
            });
            sourceReferences.forEach(s -> this.addConstraint((SourceName)s, sourceName));
            this.dataSources.get((Object)sourceName).references.addAll(sourceReferences);
        }
    }

    @Override
    public String checkAlternatives(SourceName sourceName, Optional<DataSource.DataSourceType> sourceType) {
        StringBuilder hint = new StringBuilder();
        List matchedSources = this.getAllDataSources().values().stream().filter(dataSource -> {
            boolean nameMatches = dataSource.getName().text().equalsIgnoreCase(sourceName.text());
            boolean sourceTypeMatches = sourceType.map(st -> st.equals((Object)dataSource.getDataSourceType())).orElse(true);
            return nameMatches && sourceTypeMatches;
        }).sorted(Comparator.comparing(x -> x.getName().text())).collect(Collectors.toList());
        if (matchedSources.size() > 0) {
            hint.append("\nDid you mean ");
            if (matchedSources.size() > 1) {
                int n = matchedSources.size();
                for (int i = 0; i < n; ++i) {
                    String dataSourceType = ((DataSource)matchedSources.get(i)).getDataSourceType().getKsqlType();
                    String sourceNameText = ((DataSource)matchedSources.get(i)).getName().text();
                    String punctuation = i < n - 2 ? ", " : (i == n - 2 ? (i == 0 ? " or " : ", or ") : "? ");
                    hint.append(String.format("\"%s\" (%s)%s", sourceNameText, dataSourceType, punctuation));
                }
                hint.append("Hint: wrap the source name in double quotes to make it case-sensitive.");
            } else {
                String sourceNameText = ((DataSource)matchedSources.get(0)).getName().text();
                if (sourceNameText.chars().anyMatch(Character::isLowerCase)) {
                    hint.append(String.format("\"%s\"? Hint: wrap the source name in double quotes to make it case-sensitive.", sourceNameText));
                } else {
                    hint.append(String.format("%s? Hint: try removing double quotes from the source name.", sourceNameText));
                }
            }
        }
        return hint.toString();
    }

    Set<SourceName> getSourceReferences(SourceName sourceName) {
        SourceInfo sourceInfo = this.dataSources.get(sourceName);
        if (sourceInfo == null) {
            return Collections.emptySet();
        }
        return sourceInfo.references;
    }

    private void addConstraint(SourceName source, SourceName sourceWithReference) {
        this.dropConstraints.computeIfAbsent(source, x -> ConcurrentHashMap.newKeySet()).add(sourceWithReference);
    }

    private void dropConstraint(SourceName source, SourceName sourceWithReference) {
        this.dropConstraints.computeIfPresent(source, (k, info) -> {
            info.remove(sourceWithReference);
            return info.isEmpty() ? null : info;
        });
    }

    @Override
    public Set<SourceName> getSourceConstraints(SourceName sourceName) {
        return this.dropConstraints.getOrDefault(sourceName, Collections.emptySet());
    }

    @Override
    public Map<SourceName, DataSource> getAllDataSources() {
        return this.dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((SourceInfo)entry.getValue()).source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMetaStore copy() {
        Object object = this.metaStoreLock;
        synchronized (object) {
            return new MetaStoreImpl(this.dataSources, this.functionRegistry, this.typeRegistry, this.dropConstraints);
        }
    }

    public UdfFactory getUdfFactory(FunctionName functionName) {
        return this.functionRegistry.getUdfFactory(functionName);
    }

    public boolean isAggregate(FunctionName functionName) {
        return this.functionRegistry.isAggregate(functionName);
    }

    public boolean isTableFunction(FunctionName functionName) {
        return this.functionRegistry.isTableFunction(functionName);
    }

    public boolean isPresent(FunctionName functionName) {
        return this.functionRegistry.isPresent(functionName);
    }

    public KsqlTableFunction getTableFunction(FunctionName functionName, List<SqlArgument> argumentTypes) {
        return this.functionRegistry.getTableFunction(functionName, argumentTypes);
    }

    public List<UdfFactory> listFunctions() {
        return this.functionRegistry.listFunctions();
    }

    public AggregateFunctionFactory getAggregateFactory(FunctionName functionName) {
        return this.functionRegistry.getAggregateFactory(functionName);
    }

    public TableFunctionFactory getTableFunctionFactory(FunctionName functionName) {
        return this.functionRegistry.getTableFunctionFactory(functionName);
    }

    public List<AggregateFunctionFactory> listAggregateFunctions() {
        return this.functionRegistry.listAggregateFunctions();
    }

    public List<TableFunctionFactory> listTableFunctions() {
        return this.functionRegistry.listTableFunctions();
    }

    private Stream<SourceInfo> streamSources(Set<SourceName> sourceNames) {
        return sourceNames.stream().map(sourceName -> {
            SourceInfo sourceInfo = this.dataSources.get(sourceName);
            if (sourceInfo == null) {
                throw new KsqlException("Unknown source: " + sourceName.text());
            }
            return sourceInfo;
        });
    }

    @Override
    public boolean registerType(String name, SqlType type) {
        return this.typeRegistry.registerType(name, type);
    }

    @Override
    public boolean deleteType(String name) {
        return this.typeRegistry.deleteType(name);
    }

    @Override
    public Optional<SqlType> resolveType(String name) {
        return this.typeRegistry.resolveType(name);
    }

    @Override
    public Iterator<TypeRegistry.CustomType> types() {
        return this.typeRegistry.types();
    }

    private static final class SourceInfo {
        private final DataSource source;
        private final Set<SourceName> references = new ConcurrentHashSet();

        private SourceInfo(DataSource source) {
            this.source = Objects.requireNonNull(source, "source");
        }

        private SourceInfo(DataSource source, Set<SourceName> references) {
            this.source = Objects.requireNonNull(source, "source");
            this.references.addAll((Collection<SourceName>)Objects.requireNonNull(references, "references"));
        }

        public SourceInfo copy() {
            return this.copyWith(this.source);
        }

        public SourceInfo copyWith(DataSource source) {
            return new SourceInfo(source, this.references);
        }
    }
}

