/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore;

import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class TypeRegistryImpl
implements TypeRegistry {
    private final Map<String, SqlType> typeRegistry = new ConcurrentHashMap<String, SqlType>();

    @Override
    public boolean registerType(String name, SqlType type) {
        return this.typeRegistry.putIfAbsent(name.toUpperCase(), type) == null;
    }

    @Override
    public boolean deleteType(String name) {
        return this.typeRegistry.remove(name.toUpperCase()) != null;
    }

    @Override
    public Optional<SqlType> resolveType(String name) {
        return Optional.ofNullable(this.typeRegistry.get(name.toUpperCase()));
    }

    @Override
    public Iterator<TypeRegistry.CustomType> types() {
        return this.typeRegistry.entrySet().stream().map(kv -> new TypeRegistry.CustomType((String)kv.getKey(), (SqlType)kv.getValue())).iterator();
    }
}

