/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore.model;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metastore.model.StructuredDataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Optional;

@Immutable
public class KsqlTable<K>
extends StructuredDataSource<K> {
    public KsqlTable(String sqlExpression, SourceName datasourceName, LogicalSchema schema, Optional<TimestampColumn> timestampExtractionPolicy, boolean isKsqlSink, KsqlTopic ksqlTopic, boolean isSourceTable) {
        super(sqlExpression, datasourceName, schema, timestampExtractionPolicy, DataSource.DataSourceType.KTABLE, isKsqlSink, ksqlTopic, isSourceTable);
    }

    @Override
    public DataSource with(String sql, LogicalSchema schema) {
        return new KsqlTable<K>(this.getSqlExpression() + "\n" + sql, this.getName(), schema, this.getTimestampColumn(), this.isCasTarget(), this.getKsqlTopic(), this.isSource());
    }
}

