/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client;

import io.confluent.ksql.api.client.KsqlObject;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class InsertsPublisher
implements Publisher<KsqlObject> {
    public static final int DEFAULT_BUFFER_MAX_SIZE = 200;
    private Subscriber<? super KsqlObject> subscriber;
    private final Queue<KsqlObject> buffer = new ArrayDeque<KsqlObject>();
    private final int bufferMaxSize;
    private long demand;
    private Runnable drainHandler;
    private volatile boolean cancelled;
    private boolean complete;
    private boolean shouldSendComplete;
    private boolean sentComplete;

    public InsertsPublisher() {
        this(200);
    }

    public InsertsPublisher(int bufferMaxSize) {
        this.bufferMaxSize = bufferMaxSize;
    }

    public synchronized boolean accept(KsqlObject row) {
        if (this.complete || this.sentComplete) {
            throw new IllegalStateException("Cannot call accept after complete is called");
        }
        if (!this.cancelled) {
            if (this.demand == 0L) {
                this.buffer.add(row);
            } else {
                this.doOnNext(row);
            }
        }
        return this.buffer.size() >= this.bufferMaxSize;
    }

    public synchronized void drainHandler(Runnable handler) {
        if (this.drainHandler != null) {
            throw new IllegalStateException("drainHandler already set");
        }
        this.drainHandler = Objects.requireNonNull(handler);
    }

    public synchronized void complete() {
        if (this.complete) {
            return;
        }
        this.complete = true;
        if (this.buffer.isEmpty() && this.subscriber != null) {
            this.sendComplete();
        } else {
            this.shouldSendComplete = true;
        }
    }

    public synchronized void subscribe(Subscriber<? super KsqlObject> subscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("Cannot subscribe a new subscriber: A subscriber is already present.");
        }
        this.subscriber = subscriber;
        subscriber.onSubscribe(new Subscription(){

            public void request(long l) {
                InsertsPublisher.this.doRequest(l);
            }

            public void cancel() {
                InsertsPublisher.this.doCancel();
            }
        });
    }

    private synchronized void doRequest(long n) {
        if (n <= 0L) {
            this.subscriber.onError((Throwable)new IllegalArgumentException("Amount requested must be > 0"));
        } else if (this.demand + n < 1L) {
            this.demand = Long.MAX_VALUE;
            this.maybeSend();
        } else {
            this.demand += n;
            this.maybeSend();
        }
    }

    private synchronized void doCancel() {
        this.cancelled = true;
        this.subscriber = null;
    }

    private void maybeSend() {
        while (this.demand > 0L && !this.buffer.isEmpty()) {
            KsqlObject val = this.buffer.poll();
            this.doOnNext(val);
        }
        if (this.buffer.isEmpty()) {
            if (this.shouldSendComplete) {
                this.sendComplete();
                this.shouldSendComplete = false;
            } else if (this.demand > 0L && this.drainHandler != null) {
                this.drainHandler.run();
                this.drainHandler = null;
            }
        }
    }

    private void doOnNext(KsqlObject row) {
        this.subscriber.onNext((Object)row);
        if (this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
    }

    private void sendComplete() {
        this.sentComplete = true;
        this.subscriber.onComplete();
    }
}

