/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.ConnectorDescription;
import io.confluent.ksql.api.client.ConnectorInfo;
import io.confluent.ksql.api.client.impl.AdminResponseHandlers;
import io.confluent.ksql.api.client.impl.ConnectorDescriptionImpl;
import io.confluent.ksql.api.client.impl.ConnectorInfoImpl;
import io.confluent.ksql.api.client.impl.ConnectorTypeImpl;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class ConnectorCommandResponseHandler {
    private ConnectorCommandResponseHandler() {
    }

    static void handleCreateConnectorResponse(JsonObject connectorInfoEntity, CompletableFuture<Void> cf) {
        if (AdminResponseHandlers.isCreateConnectorResponse(connectorInfoEntity)) {
            cf.complete(null);
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + String.valueOf(connectorInfoEntity)));
        }
    }

    static void handleDropConnectorResponse(JsonObject dropConnectorResponseEntity, CompletableFuture<Void> cf) {
        if (AdminResponseHandlers.isDropConnectorResponse(dropConnectorResponseEntity)) {
            cf.complete(null);
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + String.valueOf(dropConnectorResponseEntity)));
        }
    }

    static void handleListConnectorsResponse(JsonObject connectorsListEntity, CompletableFuture<List<ConnectorInfo>> cf) {
        Optional<List<ConnectorInfo>> connectors = ConnectorCommandResponseHandler.getListConnectorsResponse(connectorsListEntity);
        if (connectors.isPresent()) {
            cf.complete(connectors.get());
        } else {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + String.valueOf(connectorsListEntity)));
        }
    }

    static void handleDescribeConnectorsResponse(JsonObject connectorDescriptionEntity, CompletableFuture<ConnectorDescription> cf) {
        try {
            JsonObject status = connectorDescriptionEntity.getJsonObject("status");
            cf.complete(new ConnectorDescriptionImpl(status.getString("name"), connectorDescriptionEntity.getString("connectorClass"), connectorDescriptionEntity.getJsonArray("sources").getList(), connectorDescriptionEntity.getJsonArray("topics").getList(), new ConnectorTypeImpl(status.getString("type")), status.getJsonObject("connector").getString("state")));
        }
        catch (Exception e) {
            cf.completeExceptionally(new IllegalStateException("Unexpected server response format. Response: " + String.valueOf(connectorDescriptionEntity)));
        }
    }

    private static Optional<List<ConnectorInfo>> getListConnectorsResponse(JsonObject connectorsEntity) {
        try {
            JsonArray connectors = connectorsEntity.getJsonArray("connectors");
            return Optional.of(connectors.stream().map(o -> (JsonObject)o).map(o -> new ConnectorInfoImpl(o.getString("name"), new ConnectorTypeImpl(o.getString("type")), o.getString("className"), o.getString("state"))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

