/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.ConnectorInfo;
import io.confluent.ksql.api.client.ConnectorType;
import java.util.Objects;

public class ConnectorInfoImpl
implements ConnectorInfo {
    private final String name;
    private final ConnectorType type;
    private final String className;
    private final String state;

    public ConnectorInfoImpl(String name, ConnectorType type, String className, String state) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.className = Objects.requireNonNull(className, "className");
        this.state = Objects.requireNonNull(state, "state");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ConnectorType type() {
        return this.type;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String state() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorInfoImpl connectorInfo = (ConnectorInfoImpl)o;
        return this.name.equals(connectorInfo.name) && this.type.equals(connectorInfo.type) && this.className.equals(connectorInfo.className) && this.state.equals(connectorInfo.state);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.className, this.state);
    }

    public String toString() {
        return "ConnectorInfo{name='" + this.name + "', type=" + String.valueOf(this.type) + ", className=" + this.className + ", state=" + this.state + "}";
    }
}

