/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.ServerInfo;
import java.util.Objects;

public class ServerInfoImpl
implements ServerInfo {
    private final String serverVersion;
    private final String kafkaClusterId;
    private final String ksqlServiceId;

    public ServerInfoImpl(String serverVersion, String kafkaClusterId, String ksqlServiceId) {
        this.serverVersion = Objects.requireNonNull(serverVersion, "serverVersion");
        this.kafkaClusterId = Objects.requireNonNull(kafkaClusterId, "kafkaClusterId");
        this.ksqlServiceId = Objects.requireNonNull(ksqlServiceId, "ksqlServiceId");
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public String getKafkaClusterId() {
        return this.kafkaClusterId;
    }

    @Override
    public String getKsqlServiceId() {
        return this.ksqlServiceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfoImpl that = (ServerInfoImpl)o;
        return this.serverVersion.equals(that.serverVersion) && this.kafkaClusterId.equals(that.kafkaClusterId) && this.ksqlServiceId.equals(that.ksqlServiceId);
    }

    public int hashCode() {
        return Objects.hash(this.serverVersion, this.kafkaClusterId, this.ksqlServiceId);
    }

    public String toString() {
        return "ServerInfo{serverVersion='" + this.serverVersion + "', kafkaClusterId='" + this.kafkaClusterId + "', ksqlServiceId='" + this.ksqlServiceId + "'}";
    }
}

