/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t-v!B\u0017/\u0011\u0003)d!B\u001c/\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%IA\u0011\u0005\u0007\u0017\u0006\u0001\u000b\u0011B\"\t\u000f1\u000b!\u0019!C\u0005\u0005\"1Q*\u0001Q\u0001\n\rC\u0001BT\u0001C\u0002\u0013\u0005af\u0014\u0005\u00071\u0006\u0001\u000b\u0011\u0002)\t\u000be\u000bA\u0011\u0001.\u0007\t]r\u0003\u0001\u0018\u0005\ta*\u0011\t\u0011)A\u0005c\"AaO\u0003B\u0001B\u0003%q\u000f\u0003\u0005~\u0015\t\u0005\t\u0015!\u0003\u007f\u0011)\tIA\u0003B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003#Q!\u0011!Q\u0001\n\u0005M\u0001BB \u000b\t\u0003\t\t\u0003C\u0005\u0002.)\u0011\r\u0011\"\u0003\u00020!A\u0011Q\b\u0006!\u0002\u0013\t\t\u0004C\u0005\u0002@)\u0011\r\u0011\"\u0003\u0002B!A\u0011q\n\u0006!\u0002\u0013\t\u0019\u0005C\u0005\u0002R)\u0011\r\u0011\"\u0003\u0002T!A\u0011Q\u000e\u0006!\u0002\u0013\t)\u0006C\u0005\u0002p)\u0011\r\u0011\"\u0003\u0002r!A\u00111\u000f\u0006!\u0002\u0013\t9\u0007C\u0005\u0002v)\u0011\r\u0011\"\u0003\u0002x!A\u00111\u0012\u0006!\u0002\u0013\tI\bC\u0005\u0002\u000e*\u0011\r\u0011\"\u0003\u0002\u0010\"A\u00111\u0016\u0006!\u0002\u0013\t\t\nC\u0004\u0002.*!\t%a,\t\u000f\u0005]&\u0002\"\u0003\u00020\"A\u0011\u0011\u0018\u0006\u0005\u00029\nY\f\u0003\u0005\u0002H*!\tALA9\u0011!\tIM\u0003C\u0001]\u0005-\u0007bBAt\u0015\u0011%\u0011q\u0016\u0005\b\u0003STA\u0011IAv\u0011\u001d\tYP\u0003C\u0005\u0003{DqAa\u0001\u000b\t\u0003\u0011)\u0001C\u0004\u00036)!\tAa\u000e\t\u000f\te\"\u0002\"\u0003\u0003<!9!Q\t\u0006\u0005\u0002\t\u001d\u0003b\u0002B'\u0015\u0011%!q\n\u0005\b\u0005+RA\u0011\u0001B,\u0011\u001d\u0011yH\u0003C\u0001\u0005\u0003CqAa\"\u000b\t\u0003\u0011I)A\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJT!a\f\u0019\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003cI\n1bY8pe\u0012Lg.\u0019;pe*\t1'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005Y\nQ\"\u0001\u0018\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u0002KUs7N\\8x]\u0012+7\u000f^5oCRLwN\\)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n11\u000b\u001e:j]\u001e\fa%\u00168l]><h\u000eR3ti&t\u0017\r^5p]F+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005bunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7f\u0003\tbunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7fA\u0005YQ*\u001a;sS\u000et\u0015-\\3t+\u0005\u0001\u0006cA)W\u00076\t!K\u0003\u0002T)\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003+n\n!bY8mY\u0016\u001cG/[8o\u0013\t9&KA\u0002TKR\fA\"T3ue&\u001cg*Y7fg\u0002\nQ!\u00199qYf$Rb\u0017BG\u0005\u001f\u0013YJ!(\u0003 \n\u0005\u0006C\u0001\u001c\u000b'\rQQL\u001b\t\u0003=\"l\u0011a\u0018\u0006\u0003A\u0006\fA!\u001e;jY*\u0011!mY\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005M\"'BA3g\u0003\u0019\t\u0007/Y2iK*\tq-A\u0002pe\u001eL!![0\u0003+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u00111N\\\u0007\u0002Y*\u0011QNM\u0001\u0006kRLGn]\u0005\u0003_2\u0014q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003eRl\u0011a\u001d\u0006\u0003EJJ!!^:\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005a\\X\"A=\u000b\u0005i\u001c\u0017\u0001C7fi\u0006$\u0017\r^1\n\u0005qL(!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019aY\u0001\bG2LWM\u001c;t\u0013\u0011\t9!!\u0001\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014\bc\u0001\u001c\u0002\u000e%\u0019\u0011q\u0002\u0018\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004B!!\u0006\u0002\u001e5\u0011\u0011q\u0003\u0006\u0004[\u0006e!bAA\u000eG\u000611m\\7n_:LA!a\b\u0002\u0018\t!A+[7f)-Y\u00161EA\u0013\u0003O\tI#a\u000b\t\u000bA\u0004\u0002\u0019A9\t\u000bY\u0004\u0002\u0019A<\t\u000bu\u0004\u0002\u0019\u0001@\t\u000f\u0005%\u0001\u00031\u0001\u0002\f!9\u0011\u0011\u0003\tA\u0002\u0005M\u0011\u0001D7fiJL7m]$s_V\u0004XCAA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cC\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA\u001e\u0003k\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u00059\u0012N\u001c;fe\n\u0013xn[3s\u0019&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nI\"A\u0004oKR<xN]6\n\t\u00055\u0013q\t\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0019S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016\u0004\u0013!F7be.,'o])vKV,\u0007+\u001a:Ce>\\WM]\u000b\u0003\u0003+\u0002\u0002\"a\u0016\u0002^\u0005\u0005\u0014qM\u0007\u0003\u00033R1!a\u0017U\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003?\nIFA\u0002NCB\u00042AOA2\u0013\r\t)g\u000f\u0002\u0004\u0013:$\bc\u0001\u001c\u0002j%\u0019\u00111\u000e\u0018\u0003\u001dQCh.T1sW\u0016\u0014\u0018+^3vK\u00061R.\u0019:lKJ\u001c\u0018+^3vKB+'O\u0011:pW\u0016\u0014\b%\u0001\u000fnCJ\\WM]:Rk\u0016,XMR8s+:\\gn\\<o\u0005J|7.\u001a:\u0016\u0005\u0005\u001d\u0014!H7be.,'o])vKV,gi\u001c:V].twn\u001e8Ce>\\WM\u001d\u0011\u0002-QDh\u000eT8h\u0003B\u0004XM\u001c3SKR\u0014\u00180U;fk\u0016,\"!!\u001f\u0011\r\u0005m\u0014\u0011QAC\u001b\t\tiH\u0003\u0003\u0002\\\u0005}$B\u00011H\u0013\u0011\t\u0019)! \u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\u0007Y\n9)C\u0002\u0002\n:\u0012!\u0003U3oI&twmQ8na2,G/\u001a+y]\u00069B\u000f\u001f8M_\u001e\f\u0005\u000f]3oIJ+GO]=Rk\u0016,X\rI\u0001\u001fiJ\fgn]1di&|gn],ji\"\u0004VM\u001c3j]\u001el\u0015M]6feN,\"!!%\u0011\u0011\u0005m\u00141SAL\u0003\u000bKA!!&\u0002~\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\t\u0005e\u0015q\u0015\b\u0005\u00037\u000b\u0019\u000bE\u0002\u0002\u001enj!!a(\u000b\u0007\u0005\u0005F'\u0001\u0004=e>|GOP\u0005\u0004\u0003K[\u0014A\u0002)sK\u0012,g-C\u0002K\u0003SS1!!*<\u0003}!(/\u00198tC\u000e$\u0018n\u001c8t/&$\b\u000eU3oI&tw-T1sW\u0016\u00148\u000fI\u0001\tg\",H\u000fZ8x]R\u0011\u0011\u0011\u0017\t\u0004u\u0005M\u0016bAA[w\t!QK\\5u\u00035\u0011X-\\8wK6+GO]5dg\u0006q\u0011/^3vK\u001a{'O\u0011:pW\u0016\u0014H\u0003BA_\u0003\u0007\u0004RAOA`\u0003OJ1!!1<\u0005\u0019y\u0005\u000f^5p]\"9\u0011QY\u0010A\u0002\u0005\u0005\u0014\u0001\u00032s_.,'/\u00133\u0002+E,X-^3G_J,fn\u001b8po:\u0014%o\\6fe\u0006\u0019\u0012\r\u001a3NCJ\\WM]:G_J\u0014%o\\6feRA\u0011\u0011WAg\u00033\fi\u000eC\u0004\u0002P\u0006\u0002\r!!5\u0002\r\t\u0014xn[3s!\u0011\t\u0019.!6\u000e\u0005\u0005e\u0011\u0002BAl\u00033\u0011AAT8eK\"9\u00111\\\u0011A\u0002\u0005\u0005\u0014!\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011q\\\u0011A\u0002\u0005\u0005\u0018a\u00079f]\u0012LgnZ\"p[BdW\r^3Uq:\fe\u000eZ'be.,'\u000fE\u00027\u0003GL1!!:/\u0005\u0001\u0002VM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8B]\u0012l\u0015M]6fe\u0016sGO]=\u0002\u001fI,GO]=M_\u001e\f\u0005\u000f]3oIN\f\u0001cZ3oKJ\fG/\u001a*fcV,7\u000f^:\u0015\u0005\u00055\bCBAx\u0003c\f)0\u0004\u0002\u0002\u0000%!\u00111_A@\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004=\u0006]\u0018bAA}?\nY\"+Z9vKN$\u0018I\u001c3D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\f!c\u001e:ji\u0016$\u0006P\\\"p[BdW\r^5p]R!\u0011\u0011WA\u0000\u0011\u001d\u0011\t\u0001\na\u0001\u0003\u000b\u000b!\u0003]3oI&twmQ8na2,G/\u001a+y]\u0006\u0019\u0012\r\u001a3Uq:l\u0015M]6feN$vnU3oIRQ\u0011\u0011\u0017B\u0004\u0005\u0017\u0011YB!\n\t\u000f\t%Q\u00051\u0001\u0002b\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\b\u0005\u001b)\u0003\u0019\u0001B\b\u0003%!\bP\u001c*fgVdG\u000f\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\u0011\u0011)\"!\u0007\u0002\u0011I,\u0017/^3tiNLAA!\u0007\u0003\u0014\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\tuQ\u00051\u0001\u0003 \u0005YA\u000f\u001f8NKR\fG-\u0019;b!\r1$\u0011E\u0005\u0004\u0005Gq#a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007b\u0002B\u0014K\u0001\u0007!\u0011F\u0001\f]\u0016<X*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\ry#q\u0006\u0006\u0003c\rLAAa\r\u0003.\t\u0011B\u000b\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003eqW/\u001c+y]N<\u0016\u000e\u001e5QK:$\u0017N\\4NCJ\\WM]:\u0016\u0005\u0005\u0005\u0014\u0001\u00075bgB+g\u000eZ5oO6\u000b'o[3sgR{wK]5uKR!!Q\bB\"!\rQ$qH\u0005\u0004\u0005\u0003Z$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005;9\u0003\u0019\u0001B\u0010\u0003]i\u0017-\u001f2f/JLG/\u001a+y]\u000e{W\u000e\u001d7fi&|g\u000e\u0006\u0003\u00022\n%\u0003b\u0002B&Q\u0001\u0007\u0011qS\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006qAO]=BaB,g\u000e\u001a+p\u0019><G\u0003BAY\u0005#BqAa\u0015*\u0001\u0004\t))\u0001\u0007uq:dunZ!qa\u0016tG-\u0001\u000ebI\u0012$\u0006P\\'be.,'o\u001d+p\u0005J|7.\u001a:Rk\u0016,X\r\u0006\u0007\u00022\ne#1\rB7\u0005c\u0012\u0019\bC\u0004\u0003\\)\u0002\rA!\u0018\u0002\u0015A\u0014x\u000eZ;dKJLE\rE\u0002;\u0005?J1A!\u0019<\u0005\u0011auN\\4\t\u000f\t\u0015$\u00061\u0001\u0003h\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042A\u000fB5\u0013\r\u0011Yg\u000f\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005_R\u0003\u0019\u0001B\b\u0003\u0019\u0011Xm];mi\"9!\u0011\u0001\u0016A\u0002\u0005\u0015\u0005b\u0002B;U\u0001\u0007!qO\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB!\u0011K\u0016B=!\u0011\t\u0019Na\u001f\n\t\tu\u0014\u0011\u0004\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0005\u0012X-\\8wK6\u000b'o[3sg\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\t\tLa!\t\u000f\t\u00155\u00061\u0001\u0002b\u0005\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\u0006\u0019\"/Z7pm\u0016l\u0015M]6feN4uN\u001d+y]R!\u0011\u0011\u0017BF\u0011\u001d\u0011\t\u0001\fa\u0001\u0003\u000bCQ\u0001]\u0005A\u0002EDq!a\u000e\n\u0001\u0004\u0011\t\n\u0005\u0003\u0003\u0014\n]UB\u0001BK\u0015\u0011\t9$!\u0007\n\t\te%Q\u0013\u0002\b\u001b\u0016$(/[2t\u0011\u00151\u0018\u00021\u0001x\u0011\u001d\tI!\u0003a\u0001\u0003\u0017Aq!!\u0005\n\u0001\u0004\t\u0019\u0002C\u0004\u0003$&\u0001\rA!*\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0016\t\u001d\u0016\u0002\u0002BU\u0003/\u0011!\u0002T8h\u0007>tG/\u001a=u\u0001")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements Logging {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    public void shutdown() {
        try {
            super.shutdown();
            this.markersQueuePerBroker().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    private void removeMetrics() {
        TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        int brokerId = broker.id();
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)this.markersQueuePerBroker().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Creating new marker queue map to destination broker " + brokerId);
            return new TxnMarkerQueue(broker);
        });
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Added marker " + pendingCompleteTxnAndMarker.txnMarkerEntry() + " for transactional id " + pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId() + " to destination broker " + brokerId);
    }

    private void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Retry appending " + txnLogAppend + " transaction log");
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(pendingCompleteTxnAndMarkerEntries)));
        CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(pendingCompleteTxnAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$6(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder)request, (RequestCompletionHandler)requestCompletionHandler);
            }
            throw new MatchError(null);
        })).asJavaCollection();
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Completed sending transaction markers for " + transactionalId + "; begin transition to " + newMetadata.txnState());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "No longer the coordinator for " + transactionalId + " with coordinator epoch " + coordinatorEpoch + "; cancel appending " + newMetadata + " to transaction log");
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Loading the transaction partition that contains " + transactionalId + " while my current coordinator epoch is " + coordinatorEpoch + "; so cancel appending " + newMetadata + " to transaction log since the loading process will continue the remaining work");
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException("Unhandled error " + unexpectedError + " when fetching current transaction state");
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Sending " + transactionalId + "'s transaction markers for " + txnMetadata + " with coordinator epoch " + coordinatorEpoch + " succeeded, trying to append complete transaction log now");
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> "The cached metadata " + txnMetadata + " has changed to " + epochAndMetadata + " after completed sending the markers with coordinator epoch " + coordinatorEpoch + "; abort transiting the metadata to " + newMetadata + " as it may have been updated by another process");
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected";
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Replaced an existing pending complete txn " + prev + " with " + pendingCompleteTxn + " while adding markers to send.");
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal.noCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable)topicPartition -> OptionConverters$.MODULE$.toScala($this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName())));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        partitionsByDestination.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions.toList()).asJava());
                        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        String transactionalId = pendingCompleteTxn.transactionalId();
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> "Encountered " + error + " trying to fetch transaction metadata for " + transactionalId + " with coordinator epoch " + coordinatorEpoch + "; cancel sending markers to its partition leaders");
                            return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> "The cached metadata has changed to " + epochAndMetadata + " (old coordinator epoch is " + coordinatorEpoch + ") since preparing to send markers; cancel sending markers to its partition leaders");
                                    return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> "Couldn't find leader endpoint for partitions " + topicPartitions + " while trying to send transaction markers for " + transactionalId + ", these partitions are likely deleted already and hence can be skipped");
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected";
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        if (!this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn)) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Failed to remove pending marker entry " + current + " trying to remove " + pendingCompleteTxn);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$1(TransactionMarkerChannelManager $this) {
        return $this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public static final /* synthetic */ int $anonfun$new$2(TransactionMarkerChannelManager $this) {
        return $this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(TransactionMarkerChannelManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$6(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Completed transaction for " + txnLogAppend$2.transactionalId() + " with coordinator epoch " + txnLogAppend$2.coordinatorEpoch() + ", final state after commit: " + txnLogAppend$2.txnMetadata().state());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "No longer the coordinator for transactionalId: " + txnLogAppend$2.transactionalId() + " while trying to append to transaction log, skip writing to transaction log");
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Not available to append " + txnLogAppend$2 + ": possible causes include " + Errors.UNKNOWN_TOPIC_OR_PARTITION + ", " + Errors.NOT_ENOUGH_REPLICAS + ", " + Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND + " and " + Errors.REQUEST_TIMED_OUT + "; retry appending");
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Coordinator is loading the partition " + $this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId()) + " and hence cannot complete append of " + txnLogAppend$2 + "; skip writing to transaction log as the loading process should complete it");
            return;
        }
        if (error != null) {
            String errorMsg = "Unexpected error " + error.exceptionName() + " while appending to transaction log for " + txnLogAppend$2.transactionalId();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Removing " + entry + " for txn partition " + txnTopicPartitionId$1 + " to destination broker -1");
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Removing " + entry + " for txn partition " + txnTopicPartitionId$1 + " to destination broker " + brokerId$2);
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super("TxnMarkerSenderThread-" + config.brokerId(), (KafkaClient)networkClient, config.requestTimeoutMs(), time);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.logIdent_$eq("[Transaction Marker Channel Manager " + config.brokerId() + "]: ");
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$UnknownDestinationQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$LogAppendRetryQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$new$2(this)));
    }
}

