/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.backends.kafka;

import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class KafkaModule
extends AbstractBinder {
    protected void configure() {
        this.bindFactory(KafkaRestContextFactory.class).to(KafkaRestContext.class).in(Singleton.class);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(Singleton.class);
        this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(Singleton.class);
    }

    private static final class KafkaRestContextFactory
    implements Factory<KafkaRestContext> {
        private final KafkaRestConfig config;

        @Inject
        private KafkaRestContextFactory(KafkaRestConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        public KafkaRestContext provide() {
            return new DefaultKafkaRestContext(this.config);
        }

        public void dispose(KafkaRestContext context) {
            context.shutdown();
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final KafkaRestContext context;

        @Inject
        private AdminFactory(KafkaRestContext context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return this.context.getAdmin();
        }

        public void dispose(Admin admin) {
            admin.close();
        }
    }

    private static final class ProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final KafkaRestContext context;

        @Inject
        private ProducerFactory(KafkaRestContext context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return this.context.getProducer();
        }

        public void dispose(Producer<byte[], byte[]> producer) {
            producer.close();
        }
    }
}

