/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.common;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaFutures {
    private static final Logger log = LoggerFactory.getLogger(KafkaFutures.class);

    private KafkaFutures() {
    }

    public static <T> KafkaFuture<T> failedFuture(Throwable exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(exception);
        return future;
    }

    public static <T> CompletableFuture<T> toCompletableFuture(KafkaFuture<T> kafkaFuture) {
        CompletableFuture completableFuture = new CompletableFuture();
        kafkaFuture.whenComplete((value, exception) -> {
            if (exception == null) {
                completableFuture.complete(value);
            } else {
                log.debug("Caught Exception on completion of KafkaFuture", exception);
                completableFuture.completeExceptionally((Throwable)exception);
            }
        });
        return completableFuture;
    }
}

