/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.AbstractConfigManager;
import io.confluent.kafkarest.controllers.ClusterConfigManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import io.confluent.kafkarest.entities.ClusterConfig;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigResource;

final class ClusterConfigManagerImpl
extends AbstractConfigManager<ClusterConfig, ClusterConfig.Builder>
implements ClusterConfigManager {
    private static final String BROKER_DEFAULT_ENTITY_NAME = "";

    @Inject
    ClusterConfigManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        super(adminClient, clusterManager);
    }

    @Override
    public CompletableFuture<List<ClusterConfig>> listClusterConfigs(String clusterId, ClusterConfig.Type type) {
        return this.listConfigs(clusterId, new ConfigResource(type.getAdminType(), BROKER_DEFAULT_ENTITY_NAME), ((ClusterConfig.Builder)ClusterConfig.builder().setClusterId(clusterId)).setType(type));
    }

    @Override
    public CompletableFuture<Optional<ClusterConfig>> getClusterConfig(String clusterId, ClusterConfig.Type type, String name) {
        return this.getConfig(clusterId, new ConfigResource(type.getAdminType(), BROKER_DEFAULT_ENTITY_NAME), ((ClusterConfig.Builder)ClusterConfig.builder().setClusterId(clusterId)).setType(type), name);
    }

    @Override
    public CompletableFuture<Void> upsertClusterConfig(String clusterId, ClusterConfig.Type type, String name, String newValue) {
        return this.unsafeUpdateConfig(clusterId, new ConfigResource(type.getAdminType(), BROKER_DEFAULT_ENTITY_NAME), name, newValue);
    }

    @Override
    public CompletableFuture<Void> deleteClusterConfig(String clusterId, ClusterConfig.Type type, String name) {
        return this.safeResetConfig(clusterId, new ConfigResource(type.getAdminType(), BROKER_DEFAULT_ENTITY_NAME), ((ClusterConfig.Builder)ClusterConfig.builder().setClusterId(clusterId)).setType(type), name);
    }

    @Override
    public CompletableFuture<Void> alterClusterConfigs(String clusterId, ClusterConfig.Type type, List<AlterConfigCommand> commands) {
        return this.unsafeAlterConfigs(clusterId, new ConfigResource(type.getAdminType(), BROKER_DEFAULT_ENTITY_NAME), commands);
    }
}

