/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.controllers.AbstractConsumerLagManager;
import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.ConsumerLagManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.ConsumerGroup;
import io.confluent.kafkarest.entities.ConsumerLag;
import io.confluent.kafkarest.entities.Partition;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConsumerLagManagerImpl
extends AbstractConsumerLagManager
implements ConsumerLagManager {
    private final ConsumerGroupManager consumerGroupManager;
    private static final Logger log = LoggerFactory.getLogger(ConsumerLagManagerImpl.class);

    @Inject
    ConsumerLagManagerImpl(Admin kafkaAdminClient, ConsumerGroupManager consumerGroupManager) {
        super(kafkaAdminClient);
        this.consumerGroupManager = Objects.requireNonNull(consumerGroupManager);
    }

    @Override
    public CompletableFuture<List<ConsumerLag>> listConsumerLags(String clusterId, String consumerGroupId) {
        return ((CompletableFuture)this.consumerGroupManager.getConsumerGroup(clusterId, consumerGroupId).thenApply(consumerGroup -> (ConsumerGroup)Entities.checkEntityExists(consumerGroup, "Consumer Group %s could not be found.", consumerGroupId))).thenCompose(consumerGroup -> ((CompletableFuture)this.getCurrentOffsets(consumerGroupId).thenApply(fetchedCurrentOffsets -> ConsumerLagManagerImpl.checkOffsetsExist(fetchedCurrentOffsets, "Consumer group offsets could not be found.", new Object[0]))).thenCompose(fetchedCurrentOffsets -> this.getLatestOffsets((Map<TopicPartition, OffsetAndMetadata>)fetchedCurrentOffsets).thenApply(latestOffsets -> this.createConsumerLagList(clusterId, (ConsumerGroup)consumerGroup, (Map<TopicPartition, OffsetAndMetadata>)fetchedCurrentOffsets, (Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>)latestOffsets))));
    }

    @Override
    public CompletableFuture<Optional<ConsumerLag>> getConsumerLag(String clusterId, String consumerGroupId, String topicName, Integer partitionId) {
        return this.listConsumerLags(clusterId, consumerGroupId).thenApply(lags -> lags.stream().filter(lag -> lag.getTopicName().equals(topicName)).filter(lag -> lag.getPartitionId() == partitionId.intValue()).filter(lag -> lag.getConsumerGroupId().equals(consumerGroupId)).findAny());
    }

    List<ConsumerLag> createConsumerLagList(String clusterId, ConsumerGroup consumerGroup, Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets, Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets) {
        ImmutableMap<Partition, Consumer> partitionAssignment = consumerGroup.getPartitionAssignment();
        ArrayList<ConsumerLag> consumerLags = new ArrayList<ConsumerLag>();
        fetchedCurrentOffsets.keySet().forEach(topicPartition -> {
            Optional<Consumer> consumer = Optional.ofNullable((Consumer)partitionAssignment.get(Partition.create(clusterId, topicPartition.topic(), topicPartition.partition(), Collections.emptyList())));
            Optional<Long> currentOffset = ConsumerLagManagerImpl.getCurrentOffset(fetchedCurrentOffsets, topicPartition);
            Optional<Long> latestOffset = ConsumerLagManagerImpl.getLatestOffset(latestOffsets, topicPartition);
            if (currentOffset.isPresent() && latestOffset.isPresent()) {
                consumerLags.add(ConsumerLag.builder().setClusterId(clusterId).setConsumerGroupId(consumerGroup.getConsumerGroupId()).setTopicName(topicPartition.topic()).setPartitionId(topicPartition.partition()).setConsumerId(consumer.map(Consumer::getConsumerId).orElse("")).setInstanceId(consumer.flatMap(Consumer::getInstanceId)).setClientId(consumer.map(Consumer::getClientId).orElse("")).setCurrentOffset(currentOffset.get()).setLogEndOffset(latestOffset.get()).build());
            } else {
                log.debug("missing offset for consumerId={} topic={} partition={} current={} latest={}", new Object[]{consumer.map(Consumer::getConsumerId).orElse(""), topicPartition.topic(), topicPartition.partition(), currentOffset.orElse(null), latestOffset.orElse(null)});
            }
        });
        return consumerLags;
    }
}

