/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import io.confluent.kafka.serializers.KafkaJsonSerializer;
import io.confluent.kafka.serializers.KafkaJsonSerializerConfig;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.exceptions.BadRequestException;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;

final class NoSchemaRecordSerializer {
    private final JsonSerializer jsonSerializer;

    @Inject
    NoSchemaRecordSerializer(@ConfigModule.JsonSerializerConfigs Map<String, Object> jsonSerializerConfigs) {
        this.jsonSerializer = new JsonSerializer(jsonSerializerConfigs);
    }

    Optional<ByteString> serialize(EmbeddedFormat format, JsonNode data) {
        Preconditions.checkArgument((!format.requiresSchema() ? 1 : 0) != 0);
        if (data.isNull()) {
            return Optional.empty();
        }
        switch (format) {
            case BINARY: {
                return Optional.of(NoSchemaRecordSerializer.serializeBinary(data));
            }
            case JSON: {
                return Optional.of(this.serializeJson(data));
            }
            case STRING: {
                return Optional.of(NoSchemaRecordSerializer.serializeString(data));
            }
        }
        throw new AssertionError((Object)String.format("Unexpected enum constant: %s", new Object[]{format}));
    }

    private static ByteString serializeBinary(JsonNode data) {
        byte[] serialized;
        if (!data.isTextual()) {
            throw new BadRequestException(String.format("data=%s is not a base64 string.", data));
        }
        try {
            serialized = BaseEncoding.base64().decode((CharSequence)data.asText());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(String.format("data=%s is not a valid base64 string.", data), e);
        }
        return ByteString.copyFrom((byte[])serialized);
    }

    private ByteString serializeJson(JsonNode data) {
        return ByteString.copyFrom((byte[])this.jsonSerializer.serialize(data));
    }

    private static ByteString serializeString(JsonNode data) {
        if (!data.isTextual()) {
            throw new BadRequestException(String.format("data=%s is not a string.", data));
        }
        return ByteString.copyFromUtf8((String)data.asText());
    }

    private static final class JsonSerializer
    extends KafkaJsonSerializer<JsonNode> {
        private JsonSerializer(Map<String, Object> configs) {
            this.configure(new KafkaJsonSerializerConfig(configs));
        }

        private byte[] serialize(JsonNode data) {
            return this.serialize("", data);
        }
    }
}

