/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.ConsumerRecord;
import jakarta.annotation.Nullable;

final class AutoValue_ConsumerRecord<K, V>
extends ConsumerRecord<K, V> {
    private final String topic;
    private final K key;
    private final V value;
    private final int partition;
    private final long offset;

    AutoValue_ConsumerRecord(String topic, @Nullable K key, @Nullable V value, int partition, long offset) {
        if (topic == null) {
            throw new NullPointerException("Null topic");
        }
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.offset = offset;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public int getPartition() {
        return this.partition;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return "ConsumerRecord{topic=" + this.topic + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", partition=" + this.partition + ", offset=" + this.offset + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerRecord) {
            ConsumerRecord that = (ConsumerRecord)o;
            return this.topic.equals(that.getTopic()) && (this.key == null ? that.getKey() == null : this.key.equals(that.getKey())) && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue())) && this.partition == that.getPartition() && this.offset == that.getOffset();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.key == null ? 0 : this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.value == null ? 0 : this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition;
        h$ *= 1000003;
        return h$ ^= (int)(this.offset >>> 32 ^ this.offset);
    }
}

