/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.AutoValue_Cluster;
import io.confluent.kafkarest.entities.Broker;
import jakarta.annotation.Nullable;
import java.util.List;

@AutoValue
public abstract class Cluster {
    Cluster() {
    }

    public abstract String getClusterId();

    @Nullable
    public abstract Broker getController();

    public abstract ImmutableList<Broker> getBrokers();

    public static Builder builder() {
        return new AutoValue_Cluster.Builder();
    }

    public static Cluster create(String clusterId, @Nullable Broker controller, List<Broker> brokers) {
        return Cluster.builder().setClusterId(clusterId).setController(controller).addAllBrokers(brokers).build();
    }

    public Builder toBuilder() {
        return Cluster.builder().setClusterId(this.getClusterId()).setController(this.getController()).addAllBrokers((Iterable<Broker>)this.getBrokers());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setController(Broker var1);

        abstract ImmutableList.Builder<Broker> brokersBuilder();

        public final Builder addAllBrokers(Iterable<Broker> brokers) {
            this.brokersBuilder().addAll(brokers);
            return this;
        }

        public abstract Cluster build();
    }
}

