/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v2.ConsumerSeekRequest;
import jakarta.annotation.Nullable;
import java.util.Optional;

final class AutoValue_ConsumerSeekRequest_PartitionOffset
extends ConsumerSeekRequest.PartitionOffset {
    private final String topic;
    private final int partition;
    private final long offset;
    private final Optional<String> metadata;

    private AutoValue_ConsumerSeekRequest_PartitionOffset(String topic, int partition, long offset, Optional<String> metadata) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="topic")
    public String getTopic() {
        return this.topic;
    }

    @Override
    @JsonProperty(value="partition")
    public int getPartition() {
        return this.partition;
    }

    @Override
    @JsonProperty(value="offset")
    public long getOffset() {
        return this.offset;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "PartitionOffset{topic=" + this.topic + ", partition=" + this.partition + ", offset=" + this.offset + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerSeekRequest.PartitionOffset) {
            ConsumerSeekRequest.PartitionOffset that = (ConsumerSeekRequest.PartitionOffset)o;
            return this.topic.equals(that.getTopic()) && this.partition == that.getPartition() && this.offset == that.getOffset() && this.metadata.equals(that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition;
        h$ *= 1000003;
        h$ ^= (int)(this.offset >>> 32 ^ this.offset);
        h$ *= 1000003;
        return h$ ^= this.metadata.hashCode();
    }

    static final class Builder
    extends ConsumerSeekRequest.PartitionOffset.Builder {
        private String topic;
        private Integer partition;
        private Long offset;
        private Optional<String> metadata = Optional.empty();

        Builder() {
        }

        @Override
        public ConsumerSeekRequest.PartitionOffset.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionOffset.Builder setPartition(int partition) {
            this.partition = partition;
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionOffset.Builder setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionOffset.Builder setMetadata(@Nullable String metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        public ConsumerSeekRequest.PartitionOffset build() {
            Object missing = "";
            if (this.topic == null) {
                missing = (String)missing + " topic";
            }
            if (this.partition == null) {
                missing = (String)missing + " partition";
            }
            if (this.offset == null) {
                missing = (String)missing + " offset";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ConsumerSeekRequest_PartitionOffset(this.topic, this.partition, this.offset, this.metadata);
        }
    }
}

