/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.ConsumerInstanceConfig;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.rest.exceptions.RestConstraintViolationException;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.common.config.ConfigException;

public final class CreateConsumerInstanceRequest {
    private static final EmbeddedFormat DEFAULT_FORMAT = EmbeddedFormat.BINARY;
    public static final CreateConsumerInstanceRequest PROTOTYPE = new CreateConsumerInstanceRequest(null, null, null, null, null, null, null);
    @Nullable
    private final String id;
    @Nullable
    private final String name;
    @NotNull
    private final EmbeddedFormat format;
    @Nullable
    private final String autoOffsetReset;
    @Nullable
    private final String autoCommitEnable;
    @Nullable
    private final Integer responseMinBytes;
    @Nullable
    private final Integer requestWaitMs;

    @JsonCreator
    public CreateConsumerInstanceRequest(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="name") @Nullable String name, @JsonProperty(value="format") @Nullable String format, @JsonProperty(value="auto.offset.reset") @Nullable String autoOffsetReset, @JsonProperty(value="auto.commit.enable") @Nullable String autoCommitEnable, @JsonProperty(value="fetch.min.bytes") @JsonAlias(value={"responseMinBytes"}) @Nullable Integer responseMinBytes, @JsonProperty(value="consumer.request.timeout.ms") @JsonAlias(value={"requestWaitMs"}) @Nullable Integer requestWaitMs) {
        this.id = id;
        this.name = name;
        this.format = CreateConsumerInstanceRequest.computeFormat(format);
        this.autoOffsetReset = autoOffsetReset;
        this.autoCommitEnable = autoCommitEnable;
        this.responseMinBytes = CreateConsumerInstanceRequest.computeResponseMinBytes(responseMinBytes);
        this.requestWaitMs = requestWaitMs;
    }

    private static EmbeddedFormat computeFormat(@Nullable String format) {
        if (format == null) {
            return DEFAULT_FORMAT;
        }
        String formatCanonical = format.toUpperCase();
        for (EmbeddedFormat f : EmbeddedFormat.values()) {
            if (!f.name().equals(formatCanonical)) continue;
            return f;
        }
        throw new RestConstraintViolationException("Invalid format type.", 422);
    }

    @Nullable
    private static Integer computeResponseMinBytes(@Nullable Integer responseMinBytes) {
        if (responseMinBytes == null) {
            return null;
        }
        try {
            KafkaRestConfig.PROXY_FETCH_MIN_BYTES_VALIDATOR.ensureValid("fetch.min.bytes", (Object)responseMinBytes);
            return responseMinBytes;
        }
        catch (ConfigException e) {
            throw Errors.invalidConsumerConfigConstraintException(e);
        }
    }

    @JsonProperty
    @Nullable
    public String getId() {
        return this.id;
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFormat() {
        return this.format.name().toLowerCase();
    }

    @JsonProperty(value="auto.offset.reset")
    @Nullable
    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @JsonProperty(value="auto.commit.enable")
    @Nullable
    public String getAutoCommitEnable() {
        return this.autoCommitEnable;
    }

    @JsonProperty(value="fetch.min.bytes")
    @Nullable
    public Integer getResponseMinBytes() {
        return this.responseMinBytes;
    }

    @JsonProperty(value="consumer.request.timeout.ms")
    @Nullable
    public Integer getRequestWaitMs() {
        return this.requestWaitMs;
    }

    public ConsumerInstanceConfig toConsumerInstanceConfig() {
        return ConsumerInstanceConfig.create(this.id, this.name, this.format, this.autoOffsetReset, this.autoCommitEnable, this.responseMinBytes, this.requestWaitMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateConsumerInstanceRequest that = (CreateConsumerInstanceRequest)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.format == that.format && Objects.equals(this.autoOffsetReset, that.autoOffsetReset) && Objects.equals(this.autoCommitEnable, that.autoCommitEnable) && Objects.equals(this.responseMinBytes, that.responseMinBytes) && Objects.equals(this.requestWaitMs, that.requestWaitMs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.format, this.autoOffsetReset, this.autoCommitEnable, this.responseMinBytes, this.requestWaitMs});
    }

    public String toString() {
        return new StringJoiner(", ", CreateConsumerInstanceRequest.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("format=" + String.valueOf((Object)this.format)).add("autoOffsetReset='" + this.autoOffsetReset + "'").add("autoCommitEnable='" + this.autoCommitEnable + "'").add("responseMinBytes=" + this.responseMinBytes).add("requestWaitMs=" + this.requestWaitMs).toString();
    }
}

