/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class GetPartitionResponse {
    @PositiveOrZero
    @Nullable
    private final Integer partition;
    @PositiveOrZero
    @Nullable
    private final Integer leader;
    @Nullable
    private final List<Replica> replicas;

    @JsonCreator
    private GetPartitionResponse(@JsonProperty(value="partition") @Nullable Integer partition, @JsonProperty(value="leader") @Nullable Integer leader, @JsonProperty(value="replicas") @Nullable List<Replica> replicas) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
    }

    @JsonProperty
    @Nullable
    public Integer getPartition() {
        return this.partition;
    }

    @JsonProperty
    @Nullable
    public Integer getLeader() {
        return this.leader;
    }

    @JsonProperty
    @Nullable
    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public static GetPartitionResponse fromPartition(Partition partition) {
        List replicas = partition.getReplicas() != null ? partition.getReplicas() : Collections.emptyList();
        return new GetPartitionResponse(partition.getPartitionId(), partition.getLeader().map(PartitionReplica::getBrokerId).orElse(-1), replicas.stream().map(Replica::fromPartitionReplica).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPartitionResponse that = (GetPartitionResponse)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.leader, that.leader) && Objects.equals(this.replicas, that.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.leader, this.replicas);
    }

    public String toString() {
        return new StringJoiner(", ", GetPartitionResponse.class.getSimpleName() + "[", "]").add("partition=" + this.partition).add("leader=" + this.leader).add("replicas=" + String.valueOf(this.replicas)).toString();
    }

    public static final class Replica {
        @PositiveOrZero
        @Nullable
        private Integer broker;
        @Nullable
        private Boolean leader;
        @Nullable
        private Boolean inSync;

        @JsonCreator
        private Replica(@JsonProperty(value="broker") @Nullable Integer broker, @JsonProperty(value="leader") @Nullable Boolean leader, @JsonProperty(value="in_sync") @Nullable Boolean inSync) {
            this.broker = broker;
            this.leader = leader;
            this.inSync = inSync;
        }

        @JsonProperty(value="broker")
        @Nullable
        public Integer getBroker() {
            return this.broker;
        }

        @JsonProperty(value="leader")
        @Nullable
        public Boolean getLeader() {
            return this.leader;
        }

        @JsonProperty(value="in_sync")
        @Nullable
        public Boolean getInSync() {
            return this.inSync;
        }

        public static Replica fromPartitionReplica(PartitionReplica replica) {
            return new Replica(replica.getBrokerId(), replica.isLeader(), replica.isInSync());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Replica that = (Replica)o;
            return Objects.equals(this.broker, that.broker) && Objects.equals(this.leader, that.leader) && Objects.equals(this.inSync, that.inSync);
        }

        public int hashCode() {
            return Objects.hash(this.broker, this.leader, this.inSync);
        }

        public String toString() {
            return new StringJoiner(", ", Replica.class.getSimpleName() + "[", "]").add("broker=" + this.broker).add("leader=" + this.leader).add("inSync=" + this.inSync).toString();
        }
    }
}

