/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceRequest;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class SchemaTopicProduceRequest {
    @NotEmpty
    @Nullable
    private final List<SchemaTopicProduceRecord> records;
    @Nullable
    private final String keySchema;
    @Nullable
    private final Integer keySchemaId;
    @Nullable
    private final String valueSchema;
    @Nullable
    private final Integer valueSchemaId;

    @JsonCreator
    public SchemaTopicProduceRequest(@JsonProperty(value="records") @Nullable List<SchemaTopicProduceRecord> records, @JsonProperty(value="key_schema") @Nullable String keySchema, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="value_schema") @Nullable String valueSchema, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId) {
        this.records = records;
        this.keySchema = keySchema;
        this.keySchemaId = keySchemaId;
        this.valueSchema = valueSchema;
        this.valueSchemaId = valueSchemaId;
    }

    @JsonProperty(value="records")
    @Nullable
    public List<SchemaTopicProduceRecord> getRecords() {
        return this.records;
    }

    @JsonProperty(value="key_schema")
    @Nullable
    public String getKeySchema() {
        return this.keySchema;
    }

    @JsonProperty(value="key_schema_id")
    @Nullable
    public Integer getKeySchemaId() {
        return this.keySchemaId;
    }

    @JsonProperty(value="value_schema")
    @Nullable
    public String getValueSchema() {
        return this.valueSchema;
    }

    @JsonProperty(value="value_schema_id")
    @Nullable
    public Integer getValueSchemaId() {
        return this.valueSchemaId;
    }

    public static SchemaTopicProduceRequest create(List<SchemaTopicProduceRecord> records, @Nullable String keySchema, @Nullable Integer keySchemaId, @Nullable String valueSchema, @Nullable Integer valueSchemaId) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new SchemaTopicProduceRequest(records, keySchema, keySchemaId, valueSchema, valueSchemaId);
    }

    public ProduceRequest<JsonNode, JsonNode> toProduceRequest() {
        if (this.records == null || this.records.isEmpty()) {
            throw new IllegalStateException();
        }
        return ProduceRequest.create(this.records.stream().map(record -> ProduceRecord.create(record.key, record.value, record.partition)).collect(Collectors.toList()), this.keySchema, this.keySchemaId, this.valueSchema, this.valueSchemaId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaTopicProduceRequest that = (SchemaTopicProduceRequest)o;
        return Objects.equals(this.records, that.records) && Objects.equals(this.keySchema, that.keySchema) && Objects.equals(this.keySchemaId, that.keySchemaId) && Objects.equals(this.valueSchema, that.valueSchema) && Objects.equals(this.valueSchemaId, that.valueSchemaId);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.keySchema, this.keySchemaId, this.valueSchema, this.valueSchemaId);
    }

    public String toString() {
        return new StringJoiner(", ", SchemaTopicProduceRequest.class.getSimpleName() + "[", "]").add("records=" + String.valueOf(this.records)).add("keySchema='" + this.keySchema + "'").add("keySchemaId=" + this.keySchemaId).add("valueSchema='" + this.valueSchema + "'").add("valueSchemaId=" + this.valueSchemaId).toString();
    }

    public static final class SchemaTopicProduceRecord {
        @Nullable
        private final JsonNode key;
        @Nullable
        private final JsonNode value;
        @PositiveOrZero
        @Nullable
        private final Integer partition;

        @JsonCreator
        public SchemaTopicProduceRecord(@JsonProperty(value="key") @Nullable JsonNode key, @JsonProperty(value="value") @Nullable JsonNode value, @JsonProperty(value="partition") @Nullable Integer partition) {
            this.key = key;
            this.value = value;
            this.partition = partition;
        }

        @JsonProperty(value="key")
        @Nullable
        public JsonNode getKey() {
            return this.key;
        }

        @JsonProperty(value="value")
        @Nullable
        public JsonNode getValue() {
            return this.value;
        }

        @JsonProperty(value="partition")
        @Nullable
        public Integer getPartition() {
            return this.partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaTopicProduceRecord that = (SchemaTopicProduceRecord)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.partition, that.partition);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.partition);
        }

        public String toString() {
            return new StringJoiner(", ", SchemaTopicProduceRecord.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.key)).add("value=" + String.valueOf(this.value)).add("partition=" + this.partition).toString();
        }
    }
}

