/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.v3.ConfigSynonymData;
import jakarta.annotation.Nullable;
import java.util.Optional;

final class AutoValue_ConfigSynonymData
extends ConfigSynonymData {
    private final String name;
    private final Optional<String> value;
    private final ConfigSource source;

    private AutoValue_ConfigSynonymData(String name, Optional<String> value, ConfigSource source) {
        this.name = name;
        this.value = value;
        this.source = source;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="source")
    public ConfigSource getSource() {
        return this.source;
    }

    public String toString() {
        return "ConfigSynonymData{name=" + this.name + ", value=" + String.valueOf(this.value) + ", source=" + String.valueOf((Object)this.source) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConfigSynonymData) {
            ConfigSynonymData that = (ConfigSynonymData)o;
            return this.name.equals(that.getName()) && this.value.equals(that.getValue()) && this.source.equals((Object)that.getSource());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        return h$ ^= this.source.hashCode();
    }

    static final class Builder
    extends ConfigSynonymData.Builder {
        private String name;
        private Optional<String> value = Optional.empty();
        private ConfigSource source;

        Builder() {
        }

        @Override
        public ConfigSynonymData.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public ConfigSynonymData.Builder setValue(@Nullable String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        public ConfigSynonymData.Builder setSource(ConfigSource source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        @Override
        public ConfigSynonymData build() {
            Object missing = "";
            if (this.name == null) {
                missing = (String)missing + " name";
            }
            if (this.source == null) {
                missing = (String)missing + " source";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ConfigSynonymData(this.name, this.value, this.source);
        }
    }
}

