/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.CreateTopicRequest;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class AutoValue_CreateTopicRequest
extends CreateTopicRequest {
    private final String topicName;
    private final Optional<Integer> partitionsCount;
    private final Optional<Short> replicationFactor;
    private final Map<Integer, List<Integer>> replicasAssignments;
    private final ImmutableList<CreateTopicRequest.ConfigEntry> configs;
    private final Optional<Boolean> validateOnly;

    private AutoValue_CreateTopicRequest(String topicName, Optional<Integer> partitionsCount, Optional<Short> replicationFactor, Map<Integer, List<Integer>> replicasAssignments, ImmutableList<CreateTopicRequest.ConfigEntry> configs, Optional<Boolean> validateOnly) {
        this.topicName = topicName;
        this.partitionsCount = partitionsCount;
        this.replicationFactor = replicationFactor;
        this.replicasAssignments = replicasAssignments;
        this.configs = configs;
        this.validateOnly = validateOnly;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partitions_count")
    public Optional<Integer> getPartitionsCount() {
        return this.partitionsCount;
    }

    @Override
    @JsonProperty(value="replication_factor")
    public Optional<Short> getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @JsonProperty(value="replicas_assignments")
    public Map<Integer, List<Integer>> getReplicasAssignments() {
        return this.replicasAssignments;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<CreateTopicRequest.ConfigEntry> getConfigs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="validate_only")
    public Optional<Boolean> getValidateOnly() {
        return this.validateOnly;
    }

    public String toString() {
        return "CreateTopicRequest{topicName=" + this.topicName + ", partitionsCount=" + String.valueOf(this.partitionsCount) + ", replicationFactor=" + String.valueOf(this.replicationFactor) + ", replicasAssignments=" + String.valueOf(this.replicasAssignments) + ", configs=" + String.valueOf(this.configs) + ", validateOnly=" + String.valueOf(this.validateOnly) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateTopicRequest) {
            CreateTopicRequest that = (CreateTopicRequest)o;
            return this.topicName.equals(that.getTopicName()) && this.partitionsCount.equals(that.getPartitionsCount()) && this.replicationFactor.equals(that.getReplicationFactor()) && this.replicasAssignments.equals(that.getReplicasAssignments()) && this.configs.equals(that.getConfigs()) && this.validateOnly.equals(that.getValidateOnly());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionsCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicationFactor.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicasAssignments.hashCode();
        h$ *= 1000003;
        h$ ^= this.configs.hashCode();
        h$ *= 1000003;
        return h$ ^= this.validateOnly.hashCode();
    }

    static final class Builder
    extends CreateTopicRequest.Builder {
        private String topicName;
        private Optional<Integer> partitionsCount = Optional.empty();
        private Optional<Short> replicationFactor = Optional.empty();
        private Map<Integer, List<Integer>> replicasAssignments;
        private ImmutableList<CreateTopicRequest.ConfigEntry> configs;
        private Optional<Boolean> validateOnly = Optional.empty();

        Builder() {
        }

        @Override
        public CreateTopicRequest.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setPartitionsCount(@Nullable Integer partitionsCount) {
            this.partitionsCount = Optional.ofNullable(partitionsCount);
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setReplicationFactor(@Nullable Short replicationFactor) {
            this.replicationFactor = Optional.ofNullable(replicationFactor);
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setReplicasAssignments(Map<Integer, List<Integer>> replicasAssignments) {
            if (replicasAssignments == null) {
                throw new NullPointerException("Null replicasAssignments");
            }
            this.replicasAssignments = replicasAssignments;
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setConfigs(List<CreateTopicRequest.ConfigEntry> configs) {
            this.configs = ImmutableList.copyOf(configs);
            return this;
        }

        @Override
        public CreateTopicRequest.Builder setValidateOnly(@Nullable Boolean validateOnly) {
            this.validateOnly = Optional.ofNullable(validateOnly);
            return this;
        }

        @Override
        public CreateTopicRequest build() {
            Object missing = "";
            if (this.topicName == null) {
                missing = (String)missing + " topicName";
            }
            if (this.replicasAssignments == null) {
                missing = (String)missing + " replicasAssignments";
            }
            if (this.configs == null) {
                missing = (String)missing + " configs";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_CreateTopicRequest(this.topicName, this.partitionsCount, this.replicationFactor, this.replicasAssignments, this.configs, this.validateOnly);
        }
    }
}

