/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.TopicConfigData;
import io.confluent.kafkarest.entities.v3.TopicConfigDataList;
import java.util.List;

final class AutoValue_TopicConfigDataList
extends TopicConfigDataList {
    private final String kind;
    private final ResourceCollection.Metadata metadata;
    private final ImmutableList<TopicConfigData> data;

    private AutoValue_TopicConfigDataList(String kind, ResourceCollection.Metadata metadata, ImmutableList<TopicConfigData> data) {
        this.kind = kind;
        this.metadata = metadata;
        this.data = data;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ResourceCollection.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="data")
    public ImmutableList<TopicConfigData> getData() {
        return this.data;
    }

    public String toString() {
        return "TopicConfigDataList{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", data=" + String.valueOf(this.data) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicConfigDataList) {
            TopicConfigDataList that = (TopicConfigDataList)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.data.equals(that.getData());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.data.hashCode();
    }

    static final class Builder
    extends TopicConfigDataList.Builder {
        private String kind;
        private ResourceCollection.Metadata metadata;
        private ImmutableList<TopicConfigData> data;

        Builder() {
        }

        @Override
        public TopicConfigDataList.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public TopicConfigDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public TopicConfigDataList.Builder setData(List<TopicConfigData> data) {
            this.data = ImmutableList.copyOf(data);
            return this;
        }

        @Override
        public TopicConfigDataList build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.data == null) {
                missing = (String)missing + " data";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_TopicConfigDataList(this.kind, this.metadata, this.data);
        }
    }
}

