/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.v3.AutoValue_PartitionWithOffsetsData;
import io.confluent.kafkarest.entities.v3.Resource;

@AutoValue
public abstract class PartitionWithOffsetsData
extends Resource {
    PartitionWithOffsetsData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="earliest_offset")
    public abstract Long getEarliestOffset();

    @JsonProperty(value="latest_offset")
    public abstract Long getLatestOffset();

    public static Builder builder() {
        return new AutoValue_PartitionWithOffsetsData.Builder().setKind("KafkaPartitionWithOffsets");
    }

    public static Builder fromPartition(Partition partition) {
        return PartitionWithOffsetsData.builder().setClusterId(partition.getClusterId()).setTopicName(partition.getTopicName()).setPartitionId(partition.getPartitionId()).setEarliestOffset(partition.getEarliestOffset()).setLatestOffset(partition.getLatestOffset());
    }

    @JsonCreator
    static PartitionWithOffsetsData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="earliest_offset") Long earliestOffset, @JsonProperty(value="latest_offset") Long latestOffset) {
        return ((Builder)((Builder)PartitionWithOffsetsData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setTopicName(topicName).setPartitionId(partitionId).setEarliestOffset(earliestOffset).setLatestOffset(latestOffset).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setEarliestOffset(Long var1);

        public abstract Builder setLatestOffset(Long var1);

        public abstract PartitionWithOffsetsData build();
    }
}

