/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.v3.AutoValue_ProduceRequest;
import io.confluent.kafkarest.entities.v3.AutoValue_ProduceRequest_ProduceRequestData;
import io.confluent.kafkarest.entities.v3.AutoValue_ProduceRequest_ProduceRequestHeader;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
@AutoValue
public abstract class ProduceRequest {
    ProduceRequest() {
    }

    @JsonProperty(value="partition_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Integer> getPartitionId();

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableList<ProduceRequestHeader> getHeaders();

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<ProduceRequestData> getKey();

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<ProduceRequestData> getValue();

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Instant> getTimestamp();

    @JsonIgnore
    public abstract long getOriginalSize();

    public static Builder builder() {
        return new AutoValue_ProduceRequest.Builder().setHeaders(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        static Builder fromJson(@JsonProperty(value="partition_id") @Nullable Integer partitionId, @JsonProperty(value="headers") @Nullable List<ProduceRequestHeader> headers, @JsonProperty(value="key") @Nullable ProduceRequestData key, @JsonProperty(value="value") @Nullable ProduceRequestData value, @JsonProperty(value="timestamp") @Nullable Instant timestamp) {
            return ProduceRequest.builder().setPartitionId(partitionId).setHeaders((List<ProduceRequestHeader>)(headers != null ? headers : ImmutableList.of())).setKey(key).setValue(value).setTimestamp(timestamp);
        }

        public abstract Builder setPartitionId(@Nullable Integer var1);

        public abstract Builder setHeaders(List<ProduceRequestHeader> var1);

        public abstract Builder setKey(@Nullable ProduceRequestData var1);

        public abstract Builder setValue(@Nullable ProduceRequestData var1);

        public abstract Builder setTimestamp(@Nullable Instant var1);

        public abstract Builder setOriginalSize(long var1);

        public abstract ProduceRequest build();
    }

    public static enum EnumSubjectNameStrategy implements SubjectNameStrategy
    {
        TOPIC_NAME((SubjectNameStrategy)new TopicNameStrategy()),
        RECORD_NAME((SubjectNameStrategy)new RecordNameStrategy()),
        TOPIC_RECORD_NAME((SubjectNameStrategy)new TopicRecordNameStrategy());

        private final SubjectNameStrategy delegate;

        private EnumSubjectNameStrategy(SubjectNameStrategy delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public String subjectName(String topic, boolean isKey, ParsedSchema schema) {
            return this.delegate.subjectName(topic, isKey, schema);
        }

        public void configure(Map<String, ?> configs) {
            this.delegate.configure(configs);
        }
    }

    @AutoValue
    public static abstract class ProduceRequestData {
        ProduceRequestData() {
        }

        @JsonProperty(value="type")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<EmbeddedFormat> getFormat();

        @JsonProperty(value="subject")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<String> getSubject();

        @JsonProperty(value="subject_name_strategy")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<EnumSubjectNameStrategy> getSubjectNameStrategy();

        @JsonProperty(value="schema_id")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<Integer> getSchemaId();

        @JsonProperty(value="schema_version")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<Integer> getSchemaVersion();

        @JsonProperty(value="schema")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<String> getRawSchema();

        @JsonProperty(value="data")
        public abstract JsonNode getData();

        public static Builder builder() {
            return new AutoValue_ProduceRequest_ProduceRequestData.Builder();
        }

        @JsonCreator
        static ProduceRequestData fromJson(@JsonProperty(value="type") @Nullable EmbeddedFormat format, @JsonProperty(value="subject") @Nullable String subject, @JsonProperty(value="subject_name_strategy") @Nullable EnumSubjectNameStrategy subjectNameStrategy, @JsonProperty(value="schema_id") @Nullable Integer schemaId, @JsonProperty(value="schema_version") @Nullable Integer schemaVersion, @JsonProperty(value="schema") @Nullable String rawSchema, @JsonProperty(value="data") JsonNode data) {
            return ProduceRequestData.builder().setFormat(format).setSubjectNameStrategy(subjectNameStrategy).setSubject(subject).setSchemaId(schemaId).setSchemaVersion(schemaVersion).setRawSchema(rawSchema).setData(data).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            Builder() {
            }

            public abstract Builder setFormat(@Nullable EmbeddedFormat var1);

            public abstract Builder setSubject(@Nullable String var1);

            public abstract Builder setSubjectNameStrategy(@Nullable EnumSubjectNameStrategy var1);

            public abstract Builder setSchemaId(@Nullable Integer var1);

            public abstract Builder setSchemaVersion(@Nullable Integer var1);

            public abstract Builder setRawSchema(@Nullable String var1);

            public abstract Builder setData(JsonNode var1);

            abstract ProduceRequestData autoBuild();

            public final ProduceRequestData build() {
                ProduceRequestData request = this.autoBuild();
                Preconditions.checkState((!request.getSubjectNameStrategy().isPresent() || !request.getSubject().isPresent() ? 1 : 0) != 0, (Object)"Only one of 'subject_name_strategy' or 'subject' can be used.");
                Preconditions.checkState((boolean)(request.getSchemaId().isPresent() ? !request.getSchemaVersion().isPresent() && !request.getRawSchema().isPresent() : !request.getSchemaVersion().isPresent() || !request.getRawSchema().isPresent()), (Object)"Only one of 'schema_id', 'schema_version' or 'schema' can be used.");
                if (request.getFormat().isPresent()) {
                    if (request.getFormat().get().requiresSchema()) {
                        Preconditions.checkState((!request.getSchemaId().isPresent() ? 1 : 0) != 0, (String)"'schema_id=%s' cannot be used with 'serializer'.", request.getSchemaId().orElse(null));
                        Preconditions.checkState((!request.getSchemaVersion().isPresent() ? 1 : 0) != 0, (String)"'schema_version=%s' cannot be used with 'serializer'.", request.getSchemaVersion().orElse(null));
                        Preconditions.checkState((boolean)request.getRawSchema().isPresent(), (Object)"'schema_version=latest' cannot be used with 'serializer'.");
                    } else {
                        Preconditions.checkState((!request.getSubjectNameStrategy().isPresent() ? 1 : 0) != 0, (String)"'type=%s' cannot be used with 'subject_strategy'.", (Object)((Object)request.getFormat().get()));
                        Preconditions.checkState((!request.getSubject().isPresent() ? 1 : 0) != 0, (String)"'type=%s' cannot be used with 'subject'.", (Object)((Object)request.getFormat().get()));
                        Preconditions.checkState((!request.getSchemaId().isPresent() ? 1 : 0) != 0, (String)"'type=%s' cannot be used with 'schema_id'.", (Object)((Object)request.getFormat().get()));
                        Preconditions.checkState((!request.getSchemaVersion().isPresent() ? 1 : 0) != 0, (String)"'type=%s' cannot be used with 'schema_version'.", (Object)((Object)request.getFormat().get()));
                        Preconditions.checkState((!request.getRawSchema().isPresent() ? 1 : 0) != 0, (String)"'type=%s' cannot be used with 'schema'.", (Object)((Object)request.getFormat().get()));
                    }
                }
                return request;
            }
        }
    }

    @AutoValue
    public static abstract class ProduceRequestHeader {
        ProduceRequestHeader() {
        }

        @JsonProperty(value="name")
        public abstract String getName();

        @JsonIgnore
        public abstract Optional<ByteString> getValue();

        @JsonProperty(value="value")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        final Optional<BinaryNode> getSerializedValue() {
            return this.getValue().map(value -> BinaryNode.valueOf((byte[])value.toByteArray()));
        }

        public static ProduceRequestHeader create(String name, @Nullable ByteString value) {
            return new AutoValue_ProduceRequest_ProduceRequestHeader(name, Optional.ofNullable(value));
        }

        @JsonCreator
        static ProduceRequestHeader fromJson(@JsonProperty(value="name") String name, @JsonProperty(value="value") @Nullable byte[] value) {
            return ProduceRequestHeader.create(name, value != null ? ByteString.copyFrom((byte[])value) : null);
        }
    }

    static final class Deserializer
    extends JsonDeserializer<ProduceRequest> {
        Deserializer() {
        }

        public ProduceRequest deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            long start = parser.getCurrentLocation().getByteOffset() == -1L ? parser.getCurrentLocation().getCharOffset() : parser.getCurrentLocation().getByteOffset();
            Builder builder = (Builder)parser.readValueAs(Builder.class);
            long end = parser.getCurrentLocation().getByteOffset() == -1L ? parser.getCurrentLocation().getCharOffset() : parser.getCurrentLocation().getByteOffset();
            long size = start == -1L || end == -1L ? 0L : end - start + 1L;
            builder.setOriginalSize(size);
            return builder.build();
        }
    }
}

