/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Reassignment;
import io.confluent.kafkarest.entities.v3.AutoValue_ReassignmentData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;

@AutoValue
public abstract class ReassignmentData
extends Resource {
    ReassignmentData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="adding_replicas")
    public abstract ImmutableList<Integer> getAddingReplicas();

    @JsonProperty(value="removing_replicas")
    public abstract ImmutableList<Integer> getRemovingReplicas();

    @JsonProperty(value="replicas")
    public abstract Resource.Relationship getReplicas();

    public static Builder builder() {
        return new AutoValue_ReassignmentData.Builder().setKind("KafkaReassignment");
    }

    public static Builder fromReassignment(Reassignment reassignment) {
        return ReassignmentData.builder().setClusterId(reassignment.getClusterId()).setTopicName(reassignment.getTopicName()).setPartitionId(reassignment.getPartitionId()).setAddingReplicas((List<Integer>)reassignment.getAddingReplicas()).setRemovingReplicas((List<Integer>)reassignment.getRemovingReplicas());
    }

    @JsonCreator
    static ReassignmentData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="adding_replicas") List<Integer> addingReplicas, @JsonProperty(value="removing_replicas") List<Integer> removingReplicas, @JsonProperty(value="replicas") Resource.Relationship replicas) {
        return ((Builder)((Builder)ReassignmentData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setTopicName(topicName).setPartitionId(partitionId).setAddingReplicas(addingReplicas).setRemovingReplicas(removingReplicas).setReplicas(replicas).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setAddingReplicas(List<Integer> var1);

        public abstract Builder setRemovingReplicas(List<Integer> var1);

        public abstract Builder setReplicas(Resource.Relationship var1);

        public abstract ReassignmentData build();
    }
}

