/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.v3.AutoValue_TopicData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Set;

@AutoValue
public abstract class TopicData
extends Resource {
    TopicData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="is_internal")
    public abstract boolean isInternal();

    @JsonProperty(value="replication_factor")
    public abstract int getReplicationFactor();

    @JsonProperty(value="partitions_count")
    public abstract int getPartitionsCount();

    @JsonProperty(value="partitions")
    public abstract Resource.Relationship getPartitions();

    @JsonProperty(value="configs")
    public abstract Resource.Relationship getConfigs();

    @JsonProperty(value="partition_reassignments")
    public abstract Resource.Relationship getPartitionReassignments();

    @JsonProperty(value="authorized_operations")
    public abstract ImmutableSet<Acl.Operation> getAuthorizedOperations();

    public static Builder builder() {
        return new AutoValue_TopicData.Builder().setKind("KafkaTopic");
    }

    public static Builder fromTopic(Topic topic) {
        return TopicData.builder().setClusterId(topic.getClusterId()).setTopicName(topic.getName()).setInternal(topic.isInternal()).setReplicationFactor(topic.getReplicationFactor()).setPartitionsCount(topic.getPartitions().size()).setAuthorizedOperations(topic.getAuthorizedOperations());
    }

    @JsonCreator
    static TopicData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="is_internal") boolean isInternal, @JsonProperty(value="replication_factor") int replicationFactor, @JsonProperty(value="partitions_count") int partitionsCount, @JsonProperty(value="partitions") Resource.Relationship partitions, @JsonProperty(value="authorized_operations") ImmutableSet<Acl.Operation> authorizedOperations, @JsonProperty(value="configs") Resource.Relationship configs, @JsonProperty(value="partition_reassignments") Resource.Relationship partitionReassignments) {
        return ((Builder)((Builder)TopicData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setTopicName(topicName).setInternal(isInternal).setReplicationFactor(replicationFactor).setPartitionsCount(partitionsCount).setPartitions(partitions).setConfigs(configs).setPartitionReassignments(partitionReassignments).setAuthorizedOperations((Set<Acl.Operation>)authorizedOperations).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setInternal(boolean var1);

        public abstract Builder setReplicationFactor(int var1);

        public abstract Builder setPartitionsCount(int var1);

        public abstract Builder setPartitions(Resource.Relationship var1);

        public abstract Builder setConfigs(Resource.Relationship var1);

        public abstract Builder setPartitionReassignments(Resource.Relationship var1);

        public abstract Builder setAuthorizedOperations(Set<Acl.Operation> var1);

        public abstract TopicData build();
    }
}

