/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.extension;

import jakarta.annotation.Nullable;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@Provider
public final class InstantConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!rawType.equals(Instant.class)) {
            return null;
        }
        return new InstantConverter(DateTimeFormatter.ISO_INSTANT);
    }

    private static final class InstantConverter
    implements ParamConverter<Instant> {
        private final DateTimeFormatter formatter;

        private InstantConverter(DateTimeFormatter formatter) {
            this.formatter = Objects.requireNonNull(formatter, "formatter");
        }

        @Nullable
        public Instant fromString(@Nullable String value) {
            if (value == null) {
                return null;
            }
            return this.formatter.parse((CharSequence)value, Instant::from);
        }

        public String toString(Instant value) {
            return this.formatter.format(value);
        }
    }
}

