/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.v2.GetPartitionResponse;
import io.confluent.kafkarest.entities.v2.TopicPartitionOffsetResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/topics/{topic}/partitions")
@Consumes(value={"application/vnd.kafka.v2+json"})
@Produces(value={"application/vnd.kafka.v2+json"})
@ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.*")
public final class PartitionsResource {
    private final Provider<PartitionManager> partitionManager;

    @Inject
    public PartitionsResource(Provider<PartitionManager> partitionManager) {
        this.partitionManager = Objects.requireNonNull(partitionManager);
    }

    @GET
    @PerformanceMetric(value="partitions.list+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.list")
    public void list(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic) {
        CompletionStage response = ((PartitionManager)this.partitionManager.get()).listLocalPartitions(topic).thenApply(partitions -> partitions.stream().map(GetPartitionResponse::fromPartition).collect(Collectors.toList()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.get+v2")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.get")
    public void getPartition(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partitionId) {
        CompletionStage response = ((CompletableFuture)((PartitionManager)this.partitionManager.get()).getLocalPartition(topic, partitionId).thenApply(partition -> (Partition)partition.orElseThrow(Errors::partitionNotFoundException))).thenApply(GetPartitionResponse::fromPartition);
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{partition}/offsets")
    @ResourceAccesslistFeature.ResourceName(value="api.v2.partitions.get-offsets")
    public void getOffsets(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partitionId) {
        CompletionStage response = ((CompletableFuture)((PartitionManager)this.partitionManager.get()).getLocalPartition(topic, partitionId).thenApply(partition -> (Partition)partition.orElseThrow(Errors::partitionNotFoundException))).thenApply(partition -> new TopicPartitionOffsetResponse(partition.getEarliestOffset(), partition.getLatestOffset()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }
}

