/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.v2.ProduceRequest;
import io.confluent.kafkarest.entities.v2.ProduceResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v2.AbstractProduceAction;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Path(value="/topics")
@Consumes(value={"application/vnd.kafka.binary.v2+json", "application/vnd.kafka.json.v2+json", "application/vnd.kafka.avro.v2+json", "application/vnd.kafka.protobuf.v2+json", "application/vnd.kafka.jsonschema.v2+json"})
@Produces(value={"application/vnd.kafka.v2+json"})
@ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-topic.*")
public final class ProduceToTopicAction
extends AbstractProduceAction {
    @Inject
    public ProduceToTopicAction(Provider<SchemaManager> schemaManager, Provider<RecordSerializer> recordSerializer, Provider<ProduceController> produceController) {
        super(schemaManager, recordSerializer, produceController);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-binary+v2")
    @Consumes(value={"application/vnd.kafka.binary.v2+json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-topic.binary")
    public void produceBinary(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithoutSchema(EmbeddedFormat.BINARY, topicName, Optional.empty(), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-json+v2")
    @Consumes(value={"application/vnd.kafka.json.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-topic.json")
    public void produceJson(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithoutSchema(EmbeddedFormat.JSON, topicName, Optional.empty(), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-avro+v2")
    @Consumes(value={"application/vnd.kafka.avro.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-topic.avro")
    public void produceAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithSchema(EmbeddedFormat.AVRO, topicName, Optional.empty(), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-jsonschema+v2")
    @Consumes(value={"application/vnd.kafka.jsonschema.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-topic.json-schema")
    public void produceJsonSchema(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithSchema(EmbeddedFormat.JSONSCHEMA, topicName, Optional.empty(), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-protobuf+v2")
    @Consumes(value={"application/vnd.kafka.protobuf.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-topic.protobuf")
    public void produceProtobuf(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithSchema(EmbeddedFormat.PROTOBUF, topicName, Optional.empty(), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }
}

