/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.AclManager;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.v3.CreateAclBatchRequest;
import io.confluent.kafkarest.entities.v3.CreateAclRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/acls:batch")
@ResourceAccesslistFeature.ResourceName(value="api.v3.acls.*")
public final class CreateAclBatchAction {
    private final Provider<AclManager> aclManager;

    @Inject
    public CreateAclBatchAction(Provider<AclManager> aclManager) {
        this.aclManager = Objects.requireNonNull(aclManager);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.acls.batch-create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.acls.batch-create")
    public void createAcls(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @Valid CreateAclBatchRequest request) {
        if (request == null) {
            throw Errors.invalidPayloadException("Null input provided. Data is required.");
        }
        CompletableFuture<Void> response = ((AclManager)this.aclManager.get()).validateAclCreateParameters((List<CreateAclRequest>)request.getValue().getData().asList()).createAcls(clusterId, request.getValue().getData().stream().map(aclEntry -> Acl.builder().setClusterId(clusterId).setResourceType(aclEntry.getResourceType()).setResourceName(aclEntry.getResourceName()).setPatternType(aclEntry.getPatternType()).setPrincipal(aclEntry.getPrincipal()).setPermission(aclEntry.getPermission()).setHost(aclEntry.getHost()).setOperation(aclEntry.getOperation()).build()).collect(Collectors.toList()));
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

