/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ReassignmentManager;
import io.confluent.kafkarest.entities.Reassignment;
import io.confluent.kafkarest.entities.v3.ListAllReassignmentsResponse;
import io.confluent.kafkarest.entities.v3.ReassignmentData;
import io.confluent.kafkarest.entities.v3.ReassignmentDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/topics/-/partitions/-/reassignment")
@ResourceAccesslistFeature.ResourceName(value="api.v3.partition-reassignments.*")
public final class ListAllReassignmentsAction {
    private final Provider<ReassignmentManager> reassignmentManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ListAllReassignmentsAction(Provider<ReassignmentManager> reassignmentManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.reassignmentManager = Objects.requireNonNull(reassignmentManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics-partitions-reassignment.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.partition-reassignments.list")
    public void listReassignments(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((ReassignmentManager)this.reassignmentManager.get()).listReassignments(clusterId).thenApply(reassignments -> ListAllReassignmentsResponse.create((ReassignmentDataList)((ReassignmentDataList.Builder)((ReassignmentDataList.Builder)ReassignmentDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics", "-", "partitions", "-", "reassignments")).build())).setData(reassignments.stream().map(this::toReassignmentData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ReassignmentData toReassignmentData(Reassignment reassignment) {
        return ((ReassignmentData.Builder)ReassignmentData.fromReassignment(reassignment).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", reassignment.getClusterId(), "topics", reassignment.getTopicName(), "partitions", Integer.toString(reassignment.getPartitionId()), "reassignments")).setResourceName(this.crnFactory.create("kafka", reassignment.getClusterId(), "topic", reassignment.getTopicName(), "partition", Integer.toString(reassignment.getPartitionId()), "reassignments", null)).build())).setReplicas(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", reassignment.getClusterId(), "topics", reassignment.getTopicName(), "partitions", Integer.toString(reassignment.getPartitionId()), "replicas"))).build();
    }
}

