/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import jakarta.annotation.Nullable;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public final class FakeAsyncResponse
implements AsyncResponse {
    @GuardedBy(value="this")
    private State state = State.SUSPENDED;
    @Nullable
    @GuardedBy(value="this")
    private Object value;
    @Nullable
    @GuardedBy(value="this")
    private Throwable exception;

    public int getStatus() {
        if (this.isSuspended()) {
            throw new IllegalStateException();
        }
        return this.value instanceof Response ? ((Response)this.value).getStatus() : Response.Status.OK.getStatusCode();
    }

    @Nullable
    public Object getValue() {
        if (this.isSuspended()) {
            throw new IllegalStateException();
        }
        return this.value instanceof Response ? ((Response)this.value).getEntity() : this.value;
    }

    @Nullable
    public Throwable getException() {
        if (this.isSuspended()) {
            throw new IllegalStateException();
        }
        return this.exception;
    }

    public synchronized boolean resume(Object response) {
        if (!this.isSuspended()) {
            return false;
        }
        this.state = State.DONE;
        this.value = response;
        return true;
    }

    public synchronized boolean resume(Throwable response) {
        if (!this.isSuspended()) {
            return false;
        }
        this.state = State.DONE;
        this.exception = response;
        return true;
    }

    public synchronized boolean cancel() {
        if (!this.isSuspended()) {
            return false;
        }
        this.state = State.CANCELLED;
        return true;
    }

    public synchronized boolean cancel(int retryAfter) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean cancel(Date retryAfter) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean isSuspended() {
        return this.state == State.SUSPENDED;
    }

    public synchronized boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public synchronized boolean isDone() {
        return this.state == State.DONE;
    }

    public synchronized boolean setTimeout(long time, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        throw new UnsupportedOperationException();
    }

    public Collection<Class<?>> register(Class<?> callback) {
        throw new UnsupportedOperationException();
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
        throw new UnsupportedOperationException();
    }

    public Collection<Class<?>> register(Object callback) {
        throw new UnsupportedOperationException();
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        SUSPENDED,
        CANCELLED,
        DONE;

    }
}

