/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.response.AutoValue_UrlBuilder_QueryParameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public final class UrlBuilder {
    private final String baseUrl;
    private final List<String> pathSegments;
    private final List<QueryParameter> queryParameters;

    public UrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
        this.pathSegments = new ArrayList<String>();
        this.queryParameters = new ArrayList<QueryParameter>();
    }

    public UrlBuilder appendPathSegment(String pathSegment) {
        this.pathSegments.add(pathSegment);
        return this;
    }

    public UrlBuilder putQueryParameter(String key, String value) {
        this.queryParameters.add(QueryParameter.create(key, value));
        return this;
    }

    public String build() {
        StringBuilder url = new StringBuilder().append(this.baseUrl);
        for (String pathSegment : this.pathSegments) {
            url.append('/').append(pathSegment);
        }
        for (int i = 0; i < this.queryParameters.size(); ++i) {
            url.append(i == 0 ? (char)'?' : '&').append(this.queryParameters.get(i).asStringWithEncodedValue());
        }
        return url.toString();
    }

    @AutoValue
    static abstract class QueryParameter {
        QueryParameter() {
        }

        public abstract String getKey();

        public abstract String getValue();

        public final String asStringWithEncodedValue() {
            try {
                return this.getKey() + "=" + URLEncoder.encode(this.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public static QueryParameter create(String key, String value) {
            return new AutoValue_UrlBuilder_QueryParameter(key, value);
        }
    }
}

