/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.annotations.restrictions.RequireOnlyOne;
import com.github.rvesse.airline.annotations.restrictions.ranges.IntegerRange;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.FieldInfo;
import io.confluent.ksql.api.client.KsqlObject;
import io.confluent.ksql.api.client.SourceDescription;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.VariableParser;
import io.confluent.ksql.parser.tree.AssertSchema;
import io.confluent.ksql.parser.tree.AssertTopic;
import io.confluent.ksql.parser.tree.CreateConnector;
import io.confluent.ksql.parser.tree.DefineVariable;
import io.confluent.ksql.parser.tree.DropConnector;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.UndefineVariable;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.commands.ValidateMigrationsCommand;
import io.confluent.ksql.tools.migrations.util.CommandParser;
import io.confluent.ksql.tools.migrations.util.MetadataUtil;
import io.confluent.ksql.tools.migrations.util.MigrationFile;
import io.confluent.ksql.tools.migrations.util.MigrationsDirectoryUtil;
import io.confluent.ksql.tools.migrations.util.MigrationsUtil;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.RetryUtil;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Command(name="apply", description="Migrates the metadata schema to a new schema version.")
public class ApplyMigrationCommand
extends BaseCommand {
    private static final Logger LOGGER = LogManager.getLogger(ApplyMigrationCommand.class);
    private static final int MAX_RETRIES = 10;
    @Option(title="all", name={"-a", "--all"}, description="Run all available migrations")
    @RequireOnlyOne(tag="target")
    @Once
    private boolean all;
    @Option(title="next", name={"-n", "--next"}, description="Run the next available migration version")
    @RequireOnlyOne(tag="target")
    @Once
    private boolean next;
    @Option(title="untilVersion", name={"-u", "--until"}, arity=1, description="Run all available migrations up through the specified version")
    @RequireOnlyOne(tag="target")
    @IntegerRange(min=1, max=999999)
    @Once
    private int untilVersion;
    @Option(title="version", name={"-v", "--version"}, arity=1, description="Run the migration with the specified version")
    @RequireOnlyOne(tag="target")
    @IntegerRange(min=1, max=999999)
    @Once
    private int version;
    @Option(name={"--dry-run"}, title="dry-run", description="Dry run the current command. No ksqlDB statements will be sent to the ksqlDB server. Note that this dry run is for purposes of displaying which migration files (and what ksqlDB statements) the command would run in non-dry-run mode, and does NOT attempt to validate whether the ksqlDB statements will be accepted by the ksqlDB server.")
    @Once
    private boolean dryRun = false;
    @Option(name={"--define", "-d"}, description="Define variables for the session. This is equivalent to including DEFINE statements before each migration. The `--define` option should be followed by a string of the form `name=value` and may be passed any number of times.")
    private List<String> definedVars = null;
    @Option(name={"--headers"}, description="Path to custom request headers file. These headers will be sent with all requests to the ksqlDB server as part of applying these migrations.")
    @Once
    private String headersFile;

    @Override
    protected int command() {
        MigrationConfig config;
        if (!this.validateConfigFilePresent()) {
            return 1;
        }
        try {
            config = MigrationConfig.load(this.getConfigFile());
        }
        catch (MigrationException | KsqlException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return this.command(config, MigrationsUtil::getKsqlClient, MigrationsDirectoryUtil.getMigrationsDir(this.getConfigFile(), config), Clock.systemDefaultZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int command(MigrationConfig config, BiFunction<MigrationConfig, String, Client> clientSupplier, String migrationsDir, Clock clock) {
        boolean success;
        Client ksqlClient;
        try {
            ksqlClient = clientSupplier.apply(config, this.headersFile);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        if (!this.validateMetadataInitialized(ksqlClient, config)) {
            ksqlClient.close();
            return 1;
        }
        if (this.dryRun) {
            LOGGER.info("This is a dry run. No ksqlDB statements will be submitted to the ksqlDB server.");
        }
        try {
            success = ApplyMigrationCommand.validateCurrentState(config, ksqlClient, migrationsDir) && this.apply(config, ksqlClient, migrationsDir, clock);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            success = false;
        }
        finally {
            ksqlClient.close();
        }
        return success ? 0 : 1;
    }

    private boolean apply(MigrationConfig config, Client ksqlClient, String migrationsDir, Clock clock) {
        List<MigrationFile> migrations;
        String previous = MetadataUtil.getLatestMigratedVersion(config, ksqlClient);
        LOGGER.info("Loading migration files");
        try {
            migrations = this.loadMigrationsToApply(migrationsDir, previous);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        if (migrations.size() == 0) {
            LOGGER.info("No eligible migrations found.");
        } else {
            LOGGER.info(migrations.size() + " migration file(s) loaded.");
        }
        for (MigrationFile migration : migrations) {
            if (!this.applyMigration(config, ksqlClient, migration, clock, previous)) {
                return false;
            }
            previous = Integer.toString(migration.getVersion());
        }
        return true;
    }

    private List<MigrationFile> loadMigrationsToApply(String migrationsDir, String previousVersion) {
        int minimumVersion;
        int n = minimumVersion = previousVersion.equals("<none>") ? 1 : Integer.parseInt(previousVersion) + 1;
        if (this.version > 0) {
            Optional<MigrationFile> migration2 = MigrationsDirectoryUtil.getMigrationForVersion(String.valueOf(this.version), migrationsDir);
            if (!migration2.isPresent()) {
                throw new MigrationException("No migration file with version " + this.version + " exists.");
            }
            if (this.version < minimumVersion) {
                throw new MigrationException("Version must be newer than the last version migrated. Last version migrated was " + previousVersion);
            }
            return Collections.singletonList(migration2.get());
        }
        List<MigrationFile> migrations = MigrationsDirectoryUtil.getAllMigrations(migrationsDir).stream().filter(migration -> {
            if (migration.getVersion() < minimumVersion) {
                return false;
            }
            if (this.untilVersion > 0) {
                return migration.getVersion() <= this.untilVersion;
            }
            return true;
        }).collect(Collectors.toList());
        if (this.next) {
            if (migrations.size() == 0) {
                throw new MigrationException("No eligible migrations found.");
            }
            return Collections.singletonList(migrations.get(0));
        }
        return migrations;
    }

    private boolean applyMigration(MigrationConfig config, Client ksqlClient, MigrationFile migration, Clock clock, String previous) {
        LOGGER.info("Applying migration version {}: {}", (Object)migration.getVersion(), (Object)migration.getName());
        String migrationFileContent = MigrationsDirectoryUtil.getFileContentsForName(migration.getFilepath());
        LOGGER.info("{} contents:\n{}", (Object)migration.getFilepath(), (Object)migrationFileContent);
        if (this.dryRun) {
            LOGGER.info("Dry run complete. No migrations were actually applied.");
            return true;
        }
        if (!ApplyMigrationCommand.verifyMigrated(config, ksqlClient, previous, 10)) {
            LOGGER.error("Failed to verify status of version " + previous);
            return false;
        }
        String executionStart = Long.toString(clock.millis());
        if (!ApplyMigrationCommand.updateState(config, ksqlClient, MetadataUtil.MigrationState.RUNNING, executionStart, migration, clock, previous, Optional.empty())) {
            return false;
        }
        try {
            this.executeCommands(migrationFileContent, ksqlClient, config, executionStart, migration, clock, previous);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        if (!ApplyMigrationCommand.updateState(config, ksqlClient, MetadataUtil.MigrationState.MIGRATED, executionStart, migration, clock, previous, Optional.empty())) {
            return false;
        }
        LOGGER.info("Successfully migrated");
        return true;
    }

    private void executeCommands(String migrationFileContent, Client ksqlClient, MigrationConfig config, String executionStart, MigrationFile migration, Clock clock, String previous) {
        List<String> commands = CommandParser.splitSql(migrationFileContent);
        this.executeCommands(commands, ksqlClient, config, executionStart, migration, clock, previous, true);
        this.executeCommands(commands, ksqlClient, config, executionStart, migration, clock, previous, false);
    }

    private void executeCommands(List<String> commands, Client ksqlClient, MigrationConfig config, String executionStart, MigrationFile migration, Clock clock, String previous, boolean validateOnly) {
        this.setUpJavaClientVariables(ksqlClient);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String command : commands) {
            try {
                Map<String, String> variables = ksqlClient.getVariables().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
                CommandParser.ParsedCommand parsedCommand = CommandParser.parse(command, variables);
                this.executeCommand(parsedCommand.getStatement(), parsedCommand.getCommand(), ksqlClient, properties, validateOnly);
            }
            catch (MigrationException | InterruptedException | ExecutionException e2) {
                String action = validateOnly ? "parse" : "execute";
                String errorMsg = String.format("Failed to %s sql: %s. Error: %s", action, command, e2.getMessage());
                ApplyMigrationCommand.updateState(config, ksqlClient, MetadataUtil.MigrationState.ERROR, executionStart, migration, clock, previous, Optional.of(errorMsg));
                throw new MigrationException(errorMsg);
            }
        }
    }

    private void setUpJavaClientVariables(Client ksqlClient) {
        ksqlClient.getVariables().forEach((k, v) -> ksqlClient.undefine(k));
        try {
            VariableParser.getVariables(this.definedVars).forEach((k, v) -> ksqlClient.define(k, v));
        }
        catch (IllegalArgumentException e) {
            throw new MigrationException(e.getMessage());
        }
    }

    private void executeCommand(Optional<Statement> statement, String sql, Client ksqlClient, Map<String, Object> properties, boolean defineUndefineOnly) throws ExecutionException, InterruptedException {
        if (statement.isPresent() && statement.get() instanceof DefineVariable) {
            ksqlClient.define(((DefineVariable)statement.get()).getVariableName(), (Object)((DefineVariable)statement.get()).getVariableValue());
        } else if (statement.isPresent() && statement.get() instanceof UndefineVariable) {
            ksqlClient.undefine(((UndefineVariable)statement.get()).getVariableName());
        } else if (!defineUndefineOnly) {
            this.executeNonVariableCommands(statement, sql, ksqlClient, properties);
        }
    }

    private void executeNonVariableCommands(Optional<Statement> statement, String sql, Client ksqlClient, Map<String, Object> properties) throws ExecutionException, InterruptedException {
        if (!statement.isPresent()) {
            ksqlClient.executeStatement(sql, new HashMap<String, Object>(properties)).get();
        } else if (statement.get() instanceof InsertValues) {
            List fields = ((SourceDescription)ksqlClient.describeSource(CommandParser.preserveCase(((InsertValues)statement.get()).getTarget().text())).get()).fields();
            ksqlClient.insertInto(CommandParser.preserveCase(((InsertValues)statement.get()).getTarget().text()), ApplyMigrationCommand.getRow(fields, ((InsertValues)statement.get()).getColumns().stream().map(Name::text).collect(Collectors.toList()), ((InsertValues)statement.get()).getValues())).get();
        } else if (statement.get() instanceof CreateConnector) {
            ksqlClient.createConnector(CommandParser.preserveCase(((CreateConnector)statement.get()).getName()), ((CreateConnector)statement.get()).getType() == CreateConnector.Type.SOURCE, ((CreateConnector)statement.get()).getConfig().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CommandParser.toFieldType((Expression)e.getValue()))), ((CreateConnector)statement.get()).ifNotExists()).get();
        } else if (statement.get() instanceof DropConnector) {
            ksqlClient.dropConnector(CommandParser.preserveCase(((DropConnector)statement.get()).getConnectorName()), ((DropConnector)statement.get()).getIfExists()).get();
        } else if (statement.get() instanceof SetProperty) {
            properties.put(((SetProperty)statement.get()).getPropertyName(), ((SetProperty)statement.get()).getPropertyValue());
        } else if (statement.get() instanceof UnsetProperty) {
            properties.remove(((UnsetProperty)statement.get()).getPropertyName());
        } else if (statement.get() instanceof AssertTopic) {
            AssertTopic assertTopic = (AssertTopic)statement.get();
            Map<String, Integer> configs = assertTopic.getConfig().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)((Literal)e.getValue()).getValue()));
            if (assertTopic.getTimeout().isPresent()) {
                ksqlClient.assertTopic(assertTopic.getTopic(), configs, assertTopic.checkExists(), ((WindowTimeClause)assertTopic.getTimeout().get()).toDuration()).get();
            } else {
                ksqlClient.assertTopic(assertTopic.getTopic(), configs, assertTopic.checkExists()).get();
            }
        } else if (statement.get() instanceof AssertSchema) {
            AssertSchema assertSchema = (AssertSchema)statement.get();
            this.executeAsssertSchema(assertSchema.getSubject(), assertSchema.getId(), assertSchema.getTimeout().isPresent() ? Optional.of(((WindowTimeClause)assertSchema.getTimeout().get()).toDuration()) : Optional.empty(), assertSchema.checkExists(), ksqlClient);
        }
    }

    private void executeAsssertSchema(Optional<String> subject, Optional<Integer> id, Optional<Duration> timeout, boolean exists, Client ksqlClient) throws ExecutionException, InterruptedException {
        if (subject.isPresent() && id.isPresent() && timeout.isPresent()) {
            ksqlClient.assertSchema(subject.get(), id.get().intValue(), exists, timeout.get()).get();
        } else if (!subject.isPresent() && id.isPresent() && timeout.isPresent()) {
            ksqlClient.assertSchema(id.get().intValue(), exists, timeout.get()).get();
        } else if (subject.isPresent() && !id.isPresent() && timeout.isPresent()) {
            ksqlClient.assertSchema(subject.get(), exists, timeout.get()).get();
        } else if (subject.isPresent() && id.isPresent() && !timeout.isPresent()) {
            ksqlClient.assertSchema(subject.get(), id.get().intValue(), exists).get();
        } else if (!subject.isPresent() && id.isPresent() && !timeout.isPresent()) {
            ksqlClient.assertSchema(id.get().intValue(), exists).get();
        } else if (subject.isPresent() && !id.isPresent() && !timeout.isPresent()) {
            ksqlClient.assertSchema(subject.get(), exists).get();
        }
    }

    private static KsqlObject getRow(List<FieldInfo> sourceFields, List<String> insertColumns, List<Expression> insertValues) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        if (insertColumns.size() > 0) {
            ApplyMigrationCommand.verifyColumnValuesMatch(insertColumns, insertValues);
            for (int i = 0; i < insertColumns.size(); ++i) {
                row.put(CommandParser.preserveCase(insertColumns.get(i)), CommandParser.toFieldType(insertValues.get(i)));
            }
        } else {
            List<String> columnNames = sourceFields.stream().map(FieldInfo::name).collect(Collectors.toList());
            ApplyMigrationCommand.verifyColumnValuesMatch(columnNames, insertValues);
            for (int i = 0; i < sourceFields.size(); ++i) {
                row.put(CommandParser.preserveCase(sourceFields.get(i).name()), CommandParser.toFieldType(insertValues.get(i)));
            }
        }
        return new KsqlObject(row);
    }

    private static void verifyColumnValuesMatch(List<String> columns, List<Expression> values) {
        if (columns.size() != values.size()) {
            throw new MigrationException(String.format("Invalid `INSERT VALUES` statement. Number of columns and values must match. Got: Columns: %d. Values: %d.", columns.size(), values.size()));
        }
    }

    private static boolean verifyMigrated(MigrationConfig config, Client ksqlClient, String version, int retries) {
        if (version.equals("<none>")) {
            return true;
        }
        try {
            RetryUtil.retryWithBackoff((int)retries, (int)1000, (int)1000, () -> {
                MetadataUtil.MigrationState state = MetadataUtil.getInfoForVersion(version, config, ksqlClient).getState();
                if (!state.equals((Object)MetadataUtil.MigrationState.MIGRATED)) {
                    throw new MigrationException(String.format("Expected status MIGRATED for version %s. Got %s", new Object[]{version, state}));
                }
            }, (Class[])new Class[0]);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean updateState(MigrationConfig config, Client ksqlClient, MetadataUtil.MigrationState state, String executionStart, MigrationFile migration, Clock clock, String previous, Optional<String> errorReason) {
        String executionEnd = state == MetadataUtil.MigrationState.MIGRATED || state == MetadataUtil.MigrationState.ERROR ? Long.toString(clock.millis()) : "";
        String checksum = MigrationsDirectoryUtil.computeHashForFile(migration.getFilepath());
        try {
            MetadataUtil.writeRow(config, ksqlClient, "CURRENT", state.toString(), executionStart, executionEnd, migration, previous, checksum, errorReason).get();
            MetadataUtil.writeRow(config, ksqlClient, Integer.toString(migration.getVersion()), state.toString(), executionStart, executionEnd, migration, previous, checksum, errorReason).get();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private static boolean validateCurrentState(MigrationConfig config, Client ksqlClient, String migrationsDir) {
        LOGGER.info("Validating current migration state before applying new migrations");
        return ValidateMigrationsCommand.validate(config, migrationsDir, ksqlClient);
    }
}

